/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.registry;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;
import org.jetbrains.annotations.Nullable;

public interface Holder<T> {
    public T value();

    public boolean isBound();

    public boolean matchesKey(Key var1);

    public boolean matchesKey(ResourceKey<T> var1);

    public boolean matchesPredicate(Predicate<ResourceKey<T>> var1);

    public boolean hasTag(ResourceKey<T> var1);

    public Stream<ResourceKey<T>> tags();

    public Optional<ResourceKey<T>> keyOptional();

    public HolderKind kind();

    public boolean serializableIn(Owner<T> var1);

    default public String registeredName() {
        return this.keyOptional().map(key -> key.location().toString()).orElse("[unregistered]");
    }

    public static <T> Holder<T> direct(T value) {
        return new Direct<T>(value);
    }

    public record Direct<T>(T value) implements Holder<T>
    {
        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public boolean matchesKey(Key id) {
            return false;
        }

        @Override
        public boolean matchesKey(ResourceKey<T> key) {
            return false;
        }

        @Override
        public boolean hasTag(ResourceKey<T> tag) {
            return false;
        }

        @Override
        public boolean matchesPredicate(Predicate<ResourceKey<T>> predicate) {
            return false;
        }

        @Override
        public Optional<ResourceKey<T>> keyOptional() {
            return Optional.empty();
        }

        @Override
        public HolderKind kind() {
            return HolderKind.DIRECT;
        }

        @Override
        public boolean serializableIn(Owner<T> owner) {
            return true;
        }

        @Override
        public Stream<ResourceKey<T>> tags() {
            return Stream.of(new ResourceKey[0]);
        }

        @Override
        public String toString() {
            return "Direct{" + String.valueOf(this.value) + "}";
        }
    }

    public static interface Owner<T> {
        default public boolean canSerializeIn(Owner<T> other) {
            return other == this;
        }
    }

    public static class Reference<T>
    implements Holder<T> {
        private final Owner<T> owner;
        @Nullable
        private ResourceKey<T> key;
        @Nullable
        private T value;
        @Nullable
        private Set<ResourceKey<T>> tags;

        public Reference(Owner<T> owner, @Nullable ResourceKey<T> key, @Nullable T value) {
            this.owner = owner;
            this.key = key;
            this.value = value;
        }

        public static <T> Reference<T> create(Owner<T> owner, ResourceKey<T> registryKey) {
            return new Reference<Object>(owner, registryKey, null);
        }

        public ResourceKey<T> key() {
            if (this.key == null) {
                throw new IllegalStateException("Trying to access unbound value '" + String.valueOf(this.value) + "' from registry " + String.valueOf(this.owner));
            }
            return this.key;
        }

        @Override
        public T value() {
            if (this.value == null) {
                throw new IllegalStateException("Trying to access unbound value '" + String.valueOf(this.key) + "' from registry " + String.valueOf(this.owner));
            }
            return this.value;
        }

        @Override
        public boolean matchesKey(Key id) {
            return this.key().location().equals(id);
        }

        @Override
        public boolean matchesKey(ResourceKey<T> key) {
            return this.key() == key;
        }

        private Set<ResourceKey<T>> boundTags() {
            if (this.tags == null) {
                throw new IllegalStateException("Tags not bound");
            }
            return this.tags;
        }

        @Override
        public boolean hasTag(ResourceKey<T> tag) {
            return this.boundTags().contains(tag);
        }

        @Override
        public boolean matchesPredicate(Predicate<ResourceKey<T>> predicate) {
            return predicate.test(this.key());
        }

        @Override
        public boolean serializableIn(Owner<T> owner) {
            return this.owner.canSerializeIn(owner);
        }

        @Override
        public Optional<ResourceKey<T>> keyOptional() {
            return Optional.of(this.key());
        }

        @Override
        public HolderKind kind() {
            return HolderKind.REFERENCE;
        }

        @Override
        public boolean isBound() {
            return this.key != null && this.value != null;
        }

        public void bindKey(ResourceKey<T> registryKey) {
            if (this.key != null && registryKey != this.key) {
                throw new IllegalStateException("Can't change holder key: existing=" + String.valueOf(this.key) + ", new=" + String.valueOf(registryKey));
            }
            this.key = registryKey;
        }

        public void bindValue(T value) {
            this.value = value;
        }

        public void bindTags(Collection<ResourceKey<T>> tags) {
            this.tags = Collections.unmodifiableSet(new ReferenceOpenHashSet(tags));
        }

        @Override
        public Stream<ResourceKey<T>> tags() {
            return this.boundTags().stream();
        }

        public String toString() {
            return "Reference{" + String.valueOf(this.key) + "=" + String.valueOf(this.value) + "}";
        }
    }

    public static enum HolderKind {
        REFERENCE,
        DIRECT;

    }
}

