/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.registry;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registry;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;
import org.jetbrains.annotations.Nullable;

public class MappedRegistry<T>
implements WritableRegistry<T> {
    private final ResourceKey<? extends Registry<T>> key;
    private final Map<Key, Holder.Reference<T>> byId = new HashMap<Key, Holder.Reference<T>>(2048);
    private final Map<ResourceKey<T>, Holder.Reference<T>> byResourceKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>(2048);

    public MappedRegistry(ResourceKey<? extends Registry<T>> key) {
        this.key = key;
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    @Override
    public Holder.Reference<T> registerForHolder(ResourceKey<T> key) {
        Objects.requireNonNull(key);
        if (!key.registry().equals(this.key.location())) {
            throw new IllegalStateException(String.valueOf(key) + " is not allowed to be registered in " + String.valueOf(this.key));
        }
        if (this.byId.containsKey(key.location())) {
            throw new IllegalStateException("Adding duplicate key '" + String.valueOf(key) + "' to registry");
        }
        Holder.Reference reference = this.byResourceKey.computeIfAbsent(key, k -> Holder.Reference.create(this, k));
        this.byResourceKey.put(key, reference);
        this.byId.put(key.location(), reference);
        return reference;
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> key, T value) {
        Holder.Reference<T> holder = this.registerForHolder(key);
        holder.bindValue(value);
        return holder;
    }

    @Override
    @Nullable
    public T getValue(@Nullable ResourceKey<T> key) {
        return MappedRegistry.getValueFromNullable(this.byResourceKey.get(key));
    }

    @Override
    public Optional<Holder.Reference<T>> get(Key id) {
        return Optional.ofNullable(this.byId.get(id));
    }

    @Override
    public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
        return Optional.ofNullable(this.byResourceKey.get(key));
    }

    @Override
    @Nullable
    public T getValue(@Nullable Key id) {
        Holder.Reference<T> reference = this.byId.get(id);
        return MappedRegistry.getValueFromNullable(reference);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.Reference<T> entry) {
        return entry != null ? (T)entry.value() : null;
    }

    @Override
    public Set<Key> keySet() {
        return Collections.unmodifiableSet(this.byId.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byResourceKey.keySet());
    }

    @Override
    public boolean containsKey(Key id) {
        return this.byId.containsKey(id);
    }

    @Override
    public boolean containsKey(ResourceKey<T> key) {
        return this.byResourceKey.containsKey(key);
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byResourceKey, Holder::value).entrySet());
    }

    @Override
    public boolean isEmpty() {
        return this.byResourceKey.isEmpty();
    }
}

