/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.util.VersionHelper;

public final class MinecraftVersion
implements Comparable<MinecraftVersion> {
    public static final Map<Integer, Integer> PACK_FORMATS = new HashMap<Integer, Integer>();
    private final int version;
    private final String versionString;
    private final int packFormat;

    public static MinecraftVersion parse(String version) {
        return new MinecraftVersion(version);
    }

    public String version() {
        return this.versionString;
    }

    public int packFormat() {
        return this.packFormat;
    }

    public MinecraftVersion(String version) {
        this.version = VersionHelper.parseVersionToInteger(version);
        this.versionString = version;
        this.packFormat = PACK_FORMATS.get(this.version);
    }

    public boolean isAtOrAbove(MinecraftVersion other) {
        return this.version >= other.version;
    }

    public boolean isAtOrBelow(MinecraftVersion other) {
        return this.version <= other.version;
    }

    public boolean isAt(MinecraftVersion other) {
        return this.version == other.version;
    }

    public boolean isBelow(MinecraftVersion other) {
        return this.version < other.version;
    }

    public boolean isAbove(MinecraftVersion other) {
        return this.version > other.version;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MinecraftVersion)) {
            return false;
        }
        MinecraftVersion that = (MinecraftVersion)object;
        return this.version == that.version;
    }

    public int hashCode() {
        return this.version;
    }

    @Override
    public int compareTo(MinecraftVersion other) {
        return Integer.compare(this.version, other.version);
    }

    static {
        PACK_FORMATS.put(12000, 15);
        PACK_FORMATS.put(12001, 15);
        PACK_FORMATS.put(12002, 18);
        PACK_FORMATS.put(12003, 22);
        PACK_FORMATS.put(12004, 22);
        PACK_FORMATS.put(12005, 32);
        PACK_FORMATS.put(12006, 32);
        PACK_FORMATS.put(12100, 34);
        PACK_FORMATS.put(12101, 34);
        PACK_FORMATS.put(12102, 42);
        PACK_FORMATS.put(12103, 42);
        PACK_FORMATS.put(12104, 46);
        PACK_FORMATS.put(12105, 55);
        PACK_FORMATS.put(12106, 63);
        PACK_FORMATS.put(19999, 1000);
    }
}

