/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class ReflectionUtils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Unsafe UNSAFE;

    private ReflectionUtils() {
    }

    public static Class<?> getClazz(String ... classes) {
        for (String className : classes) {
            Class<?> clazz = ReflectionUtils.getClazz(className);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static Class<?> getClazz(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean classExists(@NotNull String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean methodExists(@NotNull Class<?> clazz, @NotNull String method, Class<?> ... parameterTypes) {
        try {
            clazz.getMethod(method, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Nullable
    public static Field getDeclaredField(Class<?> clazz, String field) {
        try {
            return ReflectionUtils.setAccessible(clazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @NotNull
    public static Field getDeclaredField(@NotNull Class<?> clazz, String ... possibleNames) {
        List<String> possibleNameList = Arrays.asList(possibleNames);
        for (Field field : clazz.getDeclaredFields()) {
            if (!possibleNameList.contains(field.getName())) continue;
            return field;
        }
        throw new RuntimeException("Class " + clazz.getName() + " does not contain a field with possible names " + Arrays.toString(possibleNames));
    }

    @Nullable
    public static Field getDeclaredField(Class<?> clazz, int index) {
        int i = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (index == i) {
                return ReflectionUtils.setAccessible(field);
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Field getInstanceDeclaredField(Class<?> clazz, int index) {
        int i = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (index == i) {
                return ReflectionUtils.setAccessible(field);
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Field getDeclaredField(Class<?> clazz, Class<?> type, int index) {
        int i = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type) continue;
            if (index == i) {
                return ReflectionUtils.setAccessible(field);
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Field getDeclaredFieldBackwards(Class<?> clazz, Class<?> type, int index) {
        int i = 0;
        Field[] fields = clazz.getDeclaredFields();
        for (int j = fields.length - 1; j >= 0; --j) {
            Field field = fields[j];
            if (field.getType() != type) continue;
            if (index == i) {
                return ReflectionUtils.setAccessible(field);
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Field getInstanceDeclaredField(@NotNull Class<?> clazz, Class<?> type, int index) {
        int i = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type || Modifier.isStatic(field.getModifiers())) continue;
            if (index == i) {
                return ReflectionUtils.setAccessible(field);
            }
            ++i;
        }
        return null;
    }

    @NotNull
    public static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            fields.add(ReflectionUtils.setAccessible(field));
        }
        return fields;
    }

    @NotNull
    public static List<Field> getInstanceDeclaredFields(@NotNull Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            list.add(ReflectionUtils.setAccessible(field));
        }
        return list;
    }

    @NotNull
    public static List<Field> getDeclaredFields(@NotNull Class<?> clazz, @NotNull Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type) continue;
            fields.add(ReflectionUtils.setAccessible(field));
        }
        return fields;
    }

    @NotNull
    public static List<Field> getInstanceDeclaredFields(@NotNull Class<?> clazz, @NotNull Class<?> type) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type || Modifier.isStatic(field.getModifiers())) continue;
            list.add(ReflectionUtils.setAccessible(field));
        }
        return list;
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, Class<?> returnType, String[] possibleMethodNames, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            for (String name : possibleMethodNames) {
                if (!name.equals(method.getName()) || !returnType.isAssignableFrom(method.getReturnType())) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, String[] possibleMethodNames, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            for (String name : possibleMethodNames) {
                if (!name.equals(method.getName())) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, Class<?> returnType, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            if (!returnType.isAssignableFrom(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getInstanceMethod(Class<?> clazz, Class<?> returnType, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != parameterTypes.length || Modifier.isStatic(method.getModifiers())) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            if (!returnType.isAssignableFrom(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getDeclaredMethod(Class<?> clazz, Class<?> returnType, String[] possibleMethodNames, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getDeclaredMethods()) {
            if (method.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            for (String name : possibleMethodNames) {
                if (!name.equals(method.getName()) || !returnType.isAssignableFrom(method.getReturnType())) continue;
                return ReflectionUtils.setAccessible(method);
            }
        }
        return null;
    }

    @Nullable
    public static Method getDeclaredMethod(Class<?> clazz, Class<?> returnType, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getDeclaredMethods()) {
            if (method.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            if (!returnType.isAssignableFrom(method.getReturnType())) continue;
            return ReflectionUtils.setAccessible(method);
        }
        return null;
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, Class<?> returnType, int index) {
        int i = 0;
        for (Method method : clazz.getMethods()) {
            if (!returnType.isAssignableFrom(method.getReturnType())) continue;
            if (i == index) {
                return ReflectionUtils.setAccessible(method);
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Method getStaticMethod(Class<?> clazz, Class<?> returnType, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != parameterTypes.length || !Modifier.isStatic(method.getModifiers())) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            if (!returnType.isAssignableFrom(method.getReturnType())) continue;
            return ReflectionUtils.setAccessible(method);
        }
        return null;
    }

    @Nullable
    public static Method getStaticMethod(Class<?> clazz, Class<?> returnType, String[] possibleNames, Class<?> ... parameterTypes) {
        block0: for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != parameterTypes.length || !Modifier.isStatic(method.getModifiers())) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            if (!returnType.isAssignableFrom(method.getReturnType())) continue;
            for (String name : possibleNames) {
                if (!name.equals(method.getName())) continue;
                return ReflectionUtils.setAccessible(method);
            }
        }
        return null;
    }

    public static Method getStaticMethod(Class<?> clazz, int index) {
        int i = 0;
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            if (i == index) {
                return ReflectionUtils.setAccessible(method);
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, int index) {
        int i = 0;
        for (Method method : clazz.getMethods()) {
            if (i == index) {
                return ReflectionUtils.setAccessible(method);
            }
            ++i;
        }
        return null;
    }

    public static Method getMethodOrElseThrow(Class<?> clazz, String[] possibleMethodNames, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method method = ReflectionUtils.getMethod(clazz, possibleMethodNames, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException("No method found with possible names " + Arrays.toString(possibleMethodNames) + " with parameters " + Arrays.toString(parameterTypes) + " in class " + clazz.getName());
        }
        return method;
    }

    @NotNull
    public static List<Method> getMethods(@NotNull Class<?> clazz, @NotNull Class<?> returnType, Class<?> ... parameterTypes) {
        ArrayList<Method> list = new ArrayList<Method>();
        block0: for (Method method : clazz.getMethods()) {
            if (!returnType.isAssignableFrom(method.getReturnType()) || method.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != parameterTypes[i]) continue block0;
            }
            list.add(method);
        }
        return list;
    }

    @NotNull
    public static <T extends AccessibleObject> T setAccessible(@NotNull T o) {
        o.setAccessible(true);
        return o;
    }

    @Nullable
    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException ignore) {
            return null;
        }
    }

    @Nullable
    public static Constructor<?> getDeclaredConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return ReflectionUtils.setAccessible(clazz.getDeclaredConstructor(parameterTypes));
        }
        catch (NoSuchMethodException | SecurityException ignore) {
            return null;
        }
    }

    @Nullable
    public static Constructor<?> getConstructor(Class<?> clazz, int index) {
        try {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            if (index < 0 || index >= constructors.length) {
                throw new IndexOutOfBoundsException("Invalid constructor index: " + index);
            }
            return ReflectionUtils.setAccessible(constructors[index]);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    @NotNull
    public static Constructor<?> getTheOnlyConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length != 1) {
            throw new RuntimeException("This class is expected to have only one constructor but it has " + constructors.length);
        }
        return constructors[0];
    }

    public static MethodHandle unreflectGetter(Field field) throws IllegalAccessException {
        try {
            return LOOKUP.unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            field.setAccessible(true);
            return LOOKUP.unreflectGetter(field);
        }
    }

    public static MethodHandle unreflectSetter(Field field) throws IllegalAccessException {
        try {
            return LOOKUP.unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            field.setAccessible(true);
            return LOOKUP.unreflectSetter(field);
        }
    }

    public static MethodHandle unreflectMethod(Method method) throws IllegalAccessException {
        try {
            return LOOKUP.unreflect(method);
        }
        catch (IllegalAccessException e) {
            method.setAccessible(true);
            return LOOKUP.unreflect(method);
        }
    }

    public static MethodHandle unreflectConstructor(Constructor<?> constructor) throws IllegalAccessException {
        try {
            return LOOKUP.unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            constructor.setAccessible(true);
            return LOOKUP.unreflectConstructor(constructor);
        }
    }

    public static VarHandle findVarHandle(Class<?> clazz, String name, Class<?> type) {
        try {
            return MethodHandles.privateLookupIn(clazz, LOOKUP).findVarHandle(clazz, name, type);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public static VarHandle findVarHandle(Field field) {
        try {
            return MethodHandles.privateLookupIn(field.getDeclaringClass(), LOOKUP).findVarHandle(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    static {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = (Unsafe)unsafeField.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

