/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeUtils {
    private static final Map<Character, Long> TIME_UNITS = new HashMap<Character, Long>(Map.of(Character.valueOf('w'), 604800000L, Character.valueOf('d'), 86400000L, Character.valueOf('h'), 3600000L, Character.valueOf('m'), 60000L, Character.valueOf('s'), 1000L));
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)([dhmsDwHMSW])", 2);

    private TimeUtils() {
    }

    public static long parseToMillis(String timeStr) {
        if (timeStr == null || timeStr.trim().isEmpty()) {
            throw new IllegalArgumentException("Time string cannot be null or empty");
        }
        String trimmedStr = timeStr.trim();
        if (trimmedStr.matches("^\\d+$")) {
            return Long.parseLong(trimmedStr);
        }
        long totalMillis = 0L;
        Matcher matcher = TIME_PATTERN.matcher(trimmedStr);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() != lastEnd) {
                throw new IllegalArgumentException("Invalid characters in time string: " + trimmedStr.substring(lastEnd, matcher.start()));
            }
            lastEnd = matcher.end();
            long value = Long.parseLong(matcher.group(1));
            if (value < 0L) {
                throw new IllegalArgumentException("Time value cannot be negative: " + value);
            }
            char unit = Character.toLowerCase(matcher.group(2).charAt(0));
            if (!TIME_UNITS.containsKey(Character.valueOf(unit))) {
                throw new IllegalArgumentException("Unknown time unit: " + unit);
            }
            try {
                totalMillis = Math.addExact(totalMillis, Math.multiplyExact(value, TIME_UNITS.get(Character.valueOf(unit))));
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Time value too large, would overflow long: " + timeStr);
            }
        }
        if (lastEnd != trimmedStr.length()) {
            throw new IllegalArgumentException("Invalid time format at position " + lastEnd + ": " + trimmedStr.substring(lastEnd));
        }
        if (totalMillis < 0L) {
            throw new IllegalArgumentException("Resulting time cannot be negative");
        }
        return totalMillis;
    }
}

