/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.chunk.serialization;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.momirealms.craftengine.core.block.BlockEntityState;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;

public final class DefaultBlockEntitySerializer {
    @ApiStatus.Experimental
    public static ListTag serialize(Map<Integer, BlockEntityState> tiles) {
        ListTag result = new ListTag();
        Object2ObjectOpenHashMap nbtToPosMap = new Object2ObjectOpenHashMap(Math.max(tiles.size(), 10), 0.75f);
        for (Map.Entry<Integer, BlockEntityState> entry : tiles.entrySet()) {
            int pos = entry.getKey();
            CompoundTag tag = entry.getValue().nbt();
            int[] previous = nbtToPosMap.computeIfAbsent(tag, k -> new int[]{pos});
            int[] newPoses = new int[previous.length + 1];
            System.arraycopy(previous, 0, newPoses, 0, previous.length);
            newPoses[previous.length] = pos;
            nbtToPosMap.put(tag, newPoses);
        }
        for (Map.Entry<Integer, BlockEntityState> entry : nbtToPosMap.entrySet()) {
            CompoundTag blockEntityTag = new CompoundTag();
            blockEntityTag.put("data", (Tag)((Object)entry.getKey()));
            blockEntityTag.putIntArray("pos", (int[])entry.getValue());
            result.add(blockEntityTag);
        }
        return result;
    }

    @ApiStatus.Experimental
    public static Map<Integer, BlockEntityState> deserialize(ListTag tag) {
        Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap(Math.max(tag.size(), 16), 0.5f);
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag blockEntityTag = tag.getCompound(i);
            CompoundTag data = blockEntityTag.getCompound("data");
            int[] pos = blockEntityTag.getIntArray("pos");
            for (int j = 0; j < pos.length; ++j) {
                result.put(j, new BlockEntityState(data));
            }
        }
        return result;
    }
}

