/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.chunk.serialization;

import java.util.Optional;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.chunk.CEChunk;
import net.momirealms.craftengine.core.world.chunk.CESection;
import net.momirealms.craftengine.core.world.chunk.serialization.DefaultBlockEntitySerializer;
import net.momirealms.craftengine.core.world.chunk.serialization.DefaultSectionSerializer;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultChunkSerializer {
    @Nullable
    public static CompoundTag serialize(@NotNull CEChunk chunk) {
        CESection[] ceSections;
        ListTag sections = new ListTag();
        for (CESection ceSection : ceSections = chunk.sections()) {
            CompoundTag sectionNbt;
            if (ceSection == null || (sectionNbt = DefaultSectionSerializer.serialize(ceSection)) == null) continue;
            sections.add(sectionNbt);
        }
        if (sections.isEmpty()) {
            return null;
        }
        CompoundTag chunkNbt = new CompoundTag();
        chunkNbt.put("sections", sections);
        chunkNbt.put("block_entities", DefaultBlockEntitySerializer.serialize(chunk.blockEntities()));
        return chunkNbt;
    }

    @NotNull
    public static CEChunk deserialize(@NotNull CEWorld world, @NotNull ChunkPos pos, @NotNull CompoundTag chunkNbt) {
        ListTag sections = chunkNbt.getList("sections");
        CESection[] sectionArray = new CESection[world.worldHeight().getSectionsCount()];
        int size = sections.size();
        for (int i = 0; i < size; ++i) {
            int sectionIndex;
            CompoundTag sectionTag = sections.getCompound(i);
            CESection ceSection = DefaultSectionSerializer.deserialize(sectionTag);
            if (ceSection == null || (sectionIndex = world.worldHeight().getSectionIndexFromSectionY(ceSection.sectionY())) < 0 || sectionIndex >= sectionArray.length) continue;
            sectionArray[sectionIndex] = ceSection;
        }
        ListTag blockEntities = Optional.ofNullable(chunkNbt.getList("block_entities")).orElse(new ListTag());
        return new CEChunk(world, pos, sectionArray, DefaultBlockEntitySerializer.deserialize(blockEntities));
    }
}

