/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;

public class BentoBoxComp
extends AbstractComp {
    public BentoBoxComp(JavaPlugin plugin) {
        super(plugin, "BentoBox");
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return BentoBox.getInstance().getIslands().getIslandAt(location).map(island -> island.isAllowed(User.getInstance((Player)player), Flags.PLACE_BLOCKS)).orElse(true);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return BentoBox.getInstance().getIslands().getIslandAt(location).map(island -> island.isAllowed(User.getInstance((Player)player), Flags.BREAK_BLOCKS)).orElse(true);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return BentoBox.getInstance().getIslands().getIslandAt(location).map(island -> island.isAllowed(User.getInstance((Player)player), Flags.CONTAINER)).orElse(true);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return BentoBox.getInstance().getIslands().getIslandAt(entity.getLocation()).map(island -> island.isAllowed(User.getInstance((Player)player), Flags.CONTAINER)).orElse(true);
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return this.entityOperation(player, entity);
    }

    private boolean entityOperation(Player player, Entity entity) {
        return BentoBox.getInstance().getIslands().getIslandAt(entity.getLocation()).map(island -> {
            User user = User.getInstance((Player)player);
            return island.isAllowed(user, switch (BentoBoxComp.getType(entity)) {
                case GameEntityType.VILLAGER -> Flags.HURT_VILLAGERS;
                case GameEntityType.HOSTILE -> Flags.HURT_MONSTERS;
                case GameEntityType.PASSIVE -> Flags.HURT_ANIMALS;
                case GameEntityType.PLAYER -> {
                    switch (entity.getWorld().getEnvironment()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORMAL: 
                        case CUSTOM: {
                            yield Flags.PVP_OVERWORLD;
                        }
                        case NETHER: {
                            yield Flags.PVP_NETHER;
                        }
                        case THE_END: 
                    }
                    yield Flags.PVP_END;
                }
                default -> Flags.CONTAINER;
            });
        }).orElse(true);
    }

    private static GameEntityType getType(Entity entity) {
        return switch (entity.getType()) {
            case EntityType.SKELETON, EntityType.STRAY, EntityType.WITHER_SKELETON, EntityType.BLAZE, EntityType.CAVE_SPIDER, EntityType.CREEPER, EntityType.DROWNED, EntityType.ELDER_GUARDIAN, EntityType.ENDERMAN, EntityType.GIANT, EntityType.GUARDIAN, EntityType.HUSK, EntityType.PILLAGER, EntityType.ILLUSIONER, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.ZOMBIFIED_PIGLIN, EntityType.EVOKER, EntityType.VINDICATOR, EntityType.RAVAGER, EntityType.WITCH, EntityType.SILVERFISH, EntityType.SPIDER, EntityType.VEX, EntityType.WARDEN, EntityType.WITHER, EntityType.ZOGLIN, EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER, EntityType.GHAST, EntityType.PHANTOM, EntityType.SLIME, EntityType.MAGMA_CUBE, EntityType.SHULKER, EntityType.ENDER_DRAGON, EntityType.ENDERMITE, EntityType.PUFFERFISH -> GameEntityType.HOSTILE;
            case EntityType.CAMEL, EntityType.DONKEY, EntityType.HORSE, EntityType.LLAMA, EntityType.MULE, EntityType.SKELETON_HORSE, EntityType.TRADER_LLAMA, EntityType.ZOMBIE_HORSE, EntityType.AXOLOTL, EntityType.BEE, EntityType.CAT, EntityType.CHICKEN, EntityType.COW, EntityType.FOX, EntityType.FROG, EntityType.GOAT, EntityType.HOGLIN, EntityType.MUSHROOM_COW, EntityType.OCELOT, EntityType.PANDA, EntityType.PARROT, EntityType.PIG, EntityType.POLAR_BEAR, EntityType.RABBIT, EntityType.SHEEP, EntityType.SNIFFER, EntityType.STRIDER, EntityType.WOLF, EntityType.IRON_GOLEM, EntityType.SNOWMAN, EntityType.COD, EntityType.DOLPHIN, EntityType.SALMON, EntityType.TADPOLE, EntityType.TROPICAL_FISH, EntityType.GLOW_SQUID, EntityType.SQUID, EntityType.BAT, EntityType.ALLAY, EntityType.TURTLE -> GameEntityType.PASSIVE;
            case EntityType.VILLAGER, EntityType.WANDERING_TRADER -> GameEntityType.VILLAGER;
            case EntityType.PLAYER -> GameEntityType.PLAYER;
            default -> GameEntityType.OTHER;
        };
    }

    private static enum GameEntityType {
        PASSIVE,
        VILLAGER,
        HOSTILE,
        PLAYER,
        OTHER;

    }
}

