/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.EntityGroup;
import codes.wasabi.xclaim.api.enums.Permission;
import java.util.Arrays;
import java.util.Optional;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class XClaimComp
extends AbstractComp {
    public XClaimComp(JavaPlugin plugin) {
        super(plugin, "XClaim");
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return Optional.ofNullable(Claim.getByChunk((Chunk)location.getChunk())).map(claim -> claim.getUserPermission((OfflinePlayer)player, Permission.BUILD)).orElse(true);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return Optional.ofNullable(Claim.getByChunk((Chunk)location.getChunk())).map(claim -> claim.getUserPermission((OfflinePlayer)player, Permission.BREAK)).orElse(true);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return Optional.ofNullable(Claim.getByChunk((Chunk)location.getChunk())).map(claim -> claim.getUserPermission((OfflinePlayer)player, Permission.INTERACT)).orElse(true);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return Optional.ofNullable(Claim.getByChunk((Chunk)entity.getLocation().getChunk())).map(claim -> claim.getUserPermission((OfflinePlayer)player, Permission.INTERACT)).orElse(true);
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        Optional<EntityGroup> og = Arrays.stream(EntityGroup.values()).filter(g -> g.contains(entity)).findFirst();
        if (og.isEmpty()) {
            return true;
        }
        EntityGroup group = og.get();
        Permission per = switch (group) {
            default -> throw new IncompatibleClassChangeError();
            case EntityGroup.FRIENDLY -> Permission.ENTITY_DAMAGE_FRIENDLY;
            case EntityGroup.HOSTILE -> Permission.ENTITY_DAMAGE_HOSTILE;
            case EntityGroup.VEHICLE -> Permission.ENTITY_DAMAGE_VEHICLE;
            case EntityGroup.NOT_ALIVE -> Permission.ENTITY_DAMAGE_NL;
            case EntityGroup.MISC -> Permission.ENTITY_DAMAGE_MISC;
        };
        return Optional.ofNullable(Claim.getByChunk((Chunk)entity.getChunk())).map(claim -> claim.getUserPermission((OfflinePlayer)player, per)).orElse(true);
    }
}

