/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.momirealms.craftengine.bukkit.block.behavior.BukkitBlockBehavior;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MFluids;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.BlockBehaviorFactory;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.block.state.properties.SlabType;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.behavior.BlockBoundItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.ItemUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockPos;

public class SlabBlockBehavior
extends BukkitBlockBehavior {
    public static final Factory FACTORY = new Factory();
    private final Property<SlabType> typeProperty;

    public SlabBlockBehavior(CustomBlock block, Property<SlabType> typeProperty) {
        super(block);
        this.typeProperty = typeProperty;
    }

    @Override
    public boolean canBeReplaced(BlockPlaceContext context, ImmutableBlockState state) {
        SlabType type = state.get(this.typeProperty);
        Item<?> item = context.getItem();
        if (type == SlabType.DOUBLE || ItemUtils.isEmpty(item)) {
            return false;
        }
        Optional<CustomItem<?>> itemInHand = item.getCustomItem();
        if (itemInHand.isEmpty()) {
            return false;
        }
        CustomItem<?> customItem = itemInHand.get();
        Key blockId = null;
        for (ItemBehavior itemBehavior : customItem.behaviors()) {
            if (!(itemBehavior instanceof BlockBoundItemBehavior)) continue;
            BlockBoundItemBehavior behavior = (BlockBoundItemBehavior)itemBehavior;
            blockId = behavior.block();
        }
        if (blockId == null || !blockId.equals(this.customBlock.id())) {
            return false;
        }
        if (!context.replacingClickedOnBlock()) {
            return true;
        }
        boolean upper = context.getClickLocation().y - (double)context.getClickedPos().y() > 0.5;
        Direction clickedFace = context.getClickedFace();
        return type == SlabType.BOTTOM ? clickedFace == Direction.UP || upper && clickedFace.axis().isHorizontal() : clickedFace == Direction.DOWN || !upper && clickedFace.axis().isHorizontal();
    }

    @Override
    public ImmutableBlockState updateStateForPlacement(BlockPlaceContext context, ImmutableBlockState state) {
        Direction clickedFace;
        BlockPos clickedPos = context.getClickedPos();
        ImmutableBlockState blockState = context.getLevel().getBlockAt(clickedPos).customBlockState();
        if (blockState != null && blockState.owner().value() == this.customBlock) {
            if (this.waterloggedProperty != null) {
                blockState = blockState.with(this.waterloggedProperty, false);
            }
            return blockState.with(this.typeProperty, SlabType.DOUBLE);
        }
        Object fluidState = FastNMS.INSTANCE.method$BlockGetter$getFluidState(context.getLevel().serverWorld(), LocationUtils.toBlockPos(clickedPos));
        if (this.waterloggedProperty != null) {
            state = state.with(this.waterloggedProperty, FastNMS.INSTANCE.method$FluidState$getType(fluidState) == MFluids.WATER);
        }
        return (clickedFace = context.getClickedFace()) == Direction.DOWN || clickedFace != Direction.UP && context.getClickLocation().y - (double)clickedPos.y() > 0.5 ? state.with(this.typeProperty, SlabType.TOP) : state.with(this.typeProperty, SlabType.BOTTOM);
    }

    @Override
    public boolean placeLiquid(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        Object blockState = args[2];
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        return optionalCustomState.filter(state -> state.get(this.typeProperty) != SlabType.DOUBLE && super.placeLiquid(thisBlock, args, superMethod)).isPresent();
    }

    @Override
    public boolean canPlaceLiquid(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        Object blockState = VersionHelper.isOrAbove1_20_2() ? args[3] : args[2];
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        return optionalCustomState.filter(state -> state.get(this.typeProperty) != SlabType.DOUBLE && super.canPlaceLiquid(thisBlock, args, superMethod)).isPresent();
    }

    @Override
    public Object updateShape(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        Object blockState = args[0];
        if (this.waterloggedProperty == null) {
            return blockState;
        }
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        if (optionalCustomState.isEmpty()) {
            return blockState;
        }
        if (optionalCustomState.get().get(this.waterloggedProperty).booleanValue()) {
            FastNMS.INSTANCE.method$ScheduledTickAccess$scheduleFluidTick(VersionHelper.isOrAbove1_21_2() ? args[2] : args[3], VersionHelper.isOrAbove1_21_2() ? args[3] : args[4], MFluids.WATER, 5);
        }
        return blockState;
    }

    @Override
    public boolean isPathFindable(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        Object type = VersionHelper.isOrAbove1_20_5() ? args[1] : args[3];
        Object blockState = args[0];
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        if (optionalCustomState.isEmpty()) {
            return false;
        }
        if (type == CoreReflections.instance$PathComputationType$WATER) {
            return this.waterloggedProperty != null && optionalCustomState.get().get(this.typeProperty) != SlabType.DOUBLE && optionalCustomState.get().get(this.waterloggedProperty) != false;
        }
        return false;
    }

    public static class Factory
    implements BlockBehaviorFactory {
        @Override
        public BlockBehavior create(CustomBlock block, Map<String, Object> arguments) {
            Property<SlabType> type = ResourceConfigUtils.requireNonNullOrThrow(block.getProperty("type"), "warning.config.block.behavior.slab.missing_type");
            return new SlabBlockBehavior(block, type);
        }
    }
}

