/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.papi;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShiftExpansion
extends PlaceholderExpansion {
    private final CraftEngine plugin;

    public ShiftExpansion(CraftEngine plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "shift";
    }

    @NotNull
    public String getAuthor() {
        return "XiaoMoMi";
    }

    @NotNull
    public String getVersion() {
        return "1.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        String[] split = params.split("_", 2);
        switch (split[0]) {
            case "mini": 
            case "minimessage": 
            case "mm": {
                if (split.length != 2) {
                    return null;
                }
                try {
                    return this.plugin.fontManager().createMiniMessageOffsets(Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case "md": 
            case "minedown": {
                if (split.length != 2) {
                    return null;
                }
                try {
                    return this.plugin.fontManager().createMineDownOffsets(Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case "raw": {
                if (split.length != 2) {
                    return null;
                }
                try {
                    return this.plugin.fontManager().createRawOffsets(Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        if (split.length != 1) {
            return null;
        }
        try {
            return this.plugin.fontManager().createMiniMessageOffsets(Integer.parseInt(split[0]));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

