/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.recipe;

import java.util.ArrayList;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeManager;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.block.BlockState;
import org.bukkit.block.Crafter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CrafterEventListener
implements Listener {
    private final ItemManager<ItemStack> itemManager;
    private final BukkitRecipeManager recipeManager;
    private final BukkitCraftEngine plugin;

    public CrafterEventListener(BukkitCraftEngine plugin, BukkitRecipeManager recipeManager, ItemManager<ItemStack> itemManager) {
        this.itemManager = itemManager;
        this.recipeManager = recipeManager;
        this.plugin = plugin;
    }

    @EventHandler
    public void onCrafting(CrafterCraftEvent event) {
        CraftingInput input;
        if (!Config.enableRecipeSystem()) {
            return;
        }
        CraftingRecipe recipe = event.getRecipe();
        BlockState blockState = event.getBlock().getState();
        if (!(blockState instanceof Crafter)) {
            return;
        }
        Crafter crafter = (Crafter)blockState;
        Key recipeId = Key.of(recipe.getKey().namespace(), recipe.getKey().value());
        boolean isCustom = this.recipeManager.isCustomRecipe(recipeId);
        if (!isCustom) {
            return;
        }
        Inventory inventory = crafter.getInventory();
        ItemStack[] ingredients = inventory.getStorageContents();
        ArrayList uniqueIdItems = new ArrayList();
        for (ItemStack itemStack : ingredients) {
            if (ItemStackUtils.isEmpty(itemStack)) {
                uniqueIdItems.add(this.itemManager.uniqueEmptyItem());
                continue;
            }
            Item<ItemStack> wrappedItem = this.itemManager.wrap(itemStack);
            uniqueIdItems.add(new UniqueIdItem<ItemStack>(wrappedItem.recipeIngredientId(), wrappedItem));
        }
        if (ingredients.length == 9) {
            input = CraftingInput.of(3, 3, uniqueIdItems);
        } else if (ingredients.length == 4) {
            input = CraftingInput.of(2, 2, uniqueIdItems);
        } else {
            return;
        }
        Recipe ceRecipe = this.recipeManager.recipeByInput(RecipeTypes.SHAPELESS, input);
        if (ceRecipe != null) {
            event.setResult((ItemStack)ceRecipe.assemble(input, ItemBuildContext.EMPTY));
            return;
        }
        ceRecipe = this.recipeManager.recipeByInput(RecipeTypes.SHAPED, input);
        if (ceRecipe != null) {
            event.setResult((ItemStack)ceRecipe.assemble(input, ItemBuildContext.EMPTY));
            return;
        }
        event.setCancelled(true);
    }
}

