/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.Set;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.sender.Sender;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DebugTargetBlockCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugTargetBlockCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.senderType(Player.class).flag(manager.flagBuilder("this").build()).handler(context -> {
            Block block;
            Player player = (Player)context.sender();
            if (context.flags().hasFlag("this")) {
                Location location = player.getLocation();
                block = location.getBlock();
            } else {
                block = player.getTargetBlockExact(10);
                if (block == null) {
                    return;
                }
            }
            String bData = block.getBlockData().getAsString();
            Object blockState = BlockStateUtils.blockDataToBlockState(block.getBlockData());
            Sender sender = this.plugin().senderFactory().wrap((Player)context.sender());
            sender.sendMessage((Component)Component.text((String)bData));
            int id = BlockStateUtils.blockStateToId(blockState);
            Object holder = BukkitBlockManager.instance().getMinecraftBlockHolder(id);
            if (holder != null) {
                ImmutableBlockState dataInCache;
                ImmutableBlockState immutableBlockState = BukkitBlockManager.instance().getImmutableBlockState(id);
                if (immutableBlockState != null) {
                    sender.sendMessage((Component)Component.text((String)immutableBlockState.toString()));
                }
                sender.sendMessage((Component)Component.text((String)("cache-state: " + !(dataInCache = this.plugin().worldManager().getWorld(block.getWorld().getUID()).getBlockStateAtIfLoaded(LocationUtils.toBlockPos(block.getLocation()))).isEmpty())));
                try {
                    Set tags = (Set)CoreReflections.field$Holder$Reference$tags.get(holder);
                    if (!tags.isEmpty()) {
                        sender.sendMessage((Component)Component.text((String)"tags: "));
                        for (Object tag : tags) {
                            sender.sendMessage((Component)Component.text((String)(" - " + CoreReflections.field$TagKey$location.get(tag).toString())));
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    this.plugin().logger().warn("Could not get tags", e);
                }
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_target_block";
    }
}

