/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.util.PlayerUtils;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.FlagKeys;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.NamespacedKeyParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.IntegerParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GetItemCommand
extends BukkitCommandFeature<CommandSender> {
    public GetItemCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.senderType(Player.class).flag(FlagKeys.SILENT_FLAG).flag(FlagKeys.TO_INVENTORY_FLAG).required("id", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(GetItemCommand.this.plugin().itemManager().cachedSuggestions());
            }
        })).optional("amount", IntegerParser.integerParser((int)1, (int)6400)).handler(context -> {
            int perStackSize;
            Player player = (Player)context.sender();
            int amount = (Integer)context.getOrDefault("amount", (Object)1);
            boolean toInv = context.flags().hasFlag("to-inventory");
            NamespacedKey namespacedKey = (NamespacedKey)context.get("id");
            Key key = Key.of(namespacedKey.namespace(), namespacedKey.value());
            ItemStack builtItem = this.plugin().itemManager().buildCustomItemStack(key, this.plugin().adapt((Player)context.sender()));
            if (builtItem == null) {
                this.handleFeedback(context, MessageConstants.COMMAND_ITEM_GET_FAILURE_NOT_EXIST, new Component[]{Component.text((String)key.toString())});
                return;
            }
            int maxStack = builtItem.getMaxStackSize();
            for (int amountToGive = amount; amountToGive > 0; amountToGive -= perStackSize) {
                perStackSize = Math.min(maxStack, amountToGive);
                ItemStack more = builtItem.clone();
                more.setAmount(perStackSize);
                if (toInv) {
                    PlayerUtils.putItemsToInventory((Inventory)player.getInventory(), more, more.getAmount());
                    continue;
                }
                PlayerUtils.dropItem(player, more, false, true, false);
            }
            this.handleFeedback(context, MessageConstants.COMMAND_ITEM_GET_SUCCESS, new Component[]{Component.text((int)amount), Component.text((String)key.toString())});
        });
    }

    @Override
    public String getFeatureID() {
        return "get_item";
    }
}

