/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.gui;

import java.util.Iterator;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.gui.BukkitClick;
import net.momirealms.craftengine.bukkit.plugin.gui.BukkitInventory;
import net.momirealms.craftengine.bukkit.plugin.gui.CraftEngineInventoryHolder;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.LegacyInventoryUtils;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.gui.AbstractGui;
import net.momirealms.craftengine.core.plugin.gui.Gui;
import net.momirealms.craftengine.core.plugin.gui.GuiManager;
import net.momirealms.craftengine.core.plugin.gui.GuiType;
import net.momirealms.craftengine.core.util.ReflectionUtils;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.CrafterView;
import org.bukkit.inventory.view.EnchantmentView;
import org.bukkit.inventory.view.LoomView;
import org.bukkit.plugin.Plugin;

public class BukkitGuiManager
implements GuiManager,
Listener {
    private static final boolean useNewOpenInventory = ReflectionUtils.getDeclaredMethod(InventoryView.class, Void.TYPE, new String[]{"open"}, new Class[0]) != null;
    private final BukkitCraftEngine plugin;

    public BukkitGuiManager(BukkitCraftEngine plugin) {
        this.plugin = plugin;
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void openInventory(net.momirealms.craftengine.core.entity.player.Player player, GuiType guiType) {
        Player bukkitPlayer = (Player)player.platformPlayer();
        if (useNewOpenInventory) {
            switch (guiType) {
                case ANVIL: {
                    ((AnvilView)MenuType.ANVIL.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case LOOM: {
                    ((LoomView)MenuType.LOOM.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case ENCHANTMENT: {
                    ((EnchantmentView)MenuType.ENCHANTMENT.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case CRAFTING: {
                    ((CrafterView)MenuType.CRAFTER_3X3.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case CARTOGRAPHY: {
                    MenuType.CARTOGRAPHY_TABLE.create((HumanEntity)bukkitPlayer).open();
                    break;
                }
                case SMITHING: {
                    MenuType.SMITHING.create((HumanEntity)bukkitPlayer).open();
                    break;
                }
                case GRINDSTONE: {
                    MenuType.GRINDSTONE.create((HumanEntity)bukkitPlayer).open();
                }
            }
        } else {
            switch (guiType) {
                case ANVIL: {
                    LegacyInventoryUtils.openAnvil(bukkitPlayer);
                    break;
                }
                case LOOM: {
                    LegacyInventoryUtils.openLoom(bukkitPlayer);
                    break;
                }
                case GRINDSTONE: {
                    LegacyInventoryUtils.openGrindstone(bukkitPlayer);
                    break;
                }
                case SMITHING: {
                    LegacyInventoryUtils.openSmithingTable(bukkitPlayer);
                    break;
                }
                case CRAFTING: {
                    LegacyInventoryUtils.openWorkbench(bukkitPlayer);
                    break;
                }
                case ENCHANTMENT: {
                    LegacyInventoryUtils.openEnchanting(bukkitPlayer);
                    break;
                }
                case CARTOGRAPHY: {
                    LegacyInventoryUtils.openCartographyTable(bukkitPlayer);
                }
            }
        }
    }

    @Override
    public void updateInventoryTitle(net.momirealms.craftengine.core.entity.player.Player player, Component component) {
        Object nmsPlayer = player.serverPlayer();
        try {
            Object containerMenu = FastNMS.INSTANCE.field$Player$containerMenu(nmsPlayer);
            int containerId = CoreReflections.field$AbstractContainerMenu$containerId.getInt(containerMenu);
            Object menuType = CoreReflections.field$AbstractContainerMenu$menuType.get(containerMenu);
            Object packet = NetworkReflections.constructor$ClientboundOpenScreenPacket.newInstance(containerId, menuType, ComponentUtils.adventureToMinecraft(component));
            player.sendPacket(packet, false);
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("Failed to update inventory title", e);
        }
    }

    @Override
    public net.momirealms.craftengine.core.plugin.gui.Inventory createInventory(Gui gui, int size) {
        CraftEngineInventoryHolder holder = new CraftEngineInventoryHolder(gui);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)size);
        holder.holder().bindValue(inventory);
        return new BukkitInventory(inventory);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof CraftEngineInventoryHolder)) {
            return;
        }
        CraftEngineInventoryHolder craftEngineInventoryHolder = (CraftEngineInventoryHolder)inventoryHolder;
        AbstractGui gui = (AbstractGui)craftEngineInventoryHolder.gui();
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() == player.getInventory()) {
            gui.handleInventoryClick(new BukkitClick(event, gui, new BukkitInventory((Inventory)player.getInventory())));
        } else if (event.getClickedInventory() == inventory) {
            gui.handleGuiClick(new BukkitClick(event, gui, new BukkitInventory(inventory)));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder() instanceof CraftEngineInventoryHolder)) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int raw = (Integer)iterator.next();
            if (raw >= inventory.getSize()) continue;
            event.setCancelled(true);
            return;
        }
    }
}

