/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.network.payload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.OptionalInt;
import net.momirealms.craftengine.bukkit.plugin.network.payload.NetWorkCodec;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.NBT;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface NetWorkCodecs {
    public static final NetWorkCodec<Boolean> BOOLEAN = new NetWorkCodec<Boolean>(){

        @Override
        public Boolean decode(ByteBuf in) {
            return in.readBoolean();
        }

        @Override
        public void encode(ByteBuf out, Boolean value) {
            out.writeBoolean(value.booleanValue());
        }
    };
    public static final NetWorkCodec<Byte> BYTE = new NetWorkCodec<Byte>(){

        @Override
        public Byte decode(ByteBuf in) {
            return in.readByte();
        }

        @Override
        public void encode(ByteBuf out, Byte value) {
            out.writeByte((int)value.byteValue());
        }
    };
    public static final NetWorkCodec<Float> ROTATION_BYTE = BYTE.map(MCUtils::unpackDegrees, MCUtils::packDegrees);
    public static final NetWorkCodec<Short> SHORT = new NetWorkCodec<Short>(){

        @Override
        public Short decode(ByteBuf in) {
            return in.readShort();
        }

        @Override
        public void encode(ByteBuf out, Short value) {
            out.writeShort((int)value.shortValue());
        }
    };
    public static final NetWorkCodec<Integer> UNSIGNED_SHORT = new NetWorkCodec<Integer>(){

        @Override
        public Integer decode(ByteBuf in) {
            return in.readUnsignedShort();
        }

        @Override
        public void encode(ByteBuf out, Integer value) {
            out.writeShort(value.intValue());
        }
    };
    public static final NetWorkCodec<Integer> INTEGER = new NetWorkCodec<Integer>(){

        @Override
        public Integer decode(ByteBuf in) {
            return in.readInt();
        }

        @Override
        public void encode(ByteBuf out, Integer value) {
            out.writeInt(value.intValue());
        }
    };
    public static final NetWorkCodec<Integer> VAR_INTEGER = new NetWorkCodec<Integer>(){

        @Override
        public Integer decode(ByteBuf in) {
            byte currentByte;
            int result = 0;
            int bytesRead = 0;
            do {
                currentByte = in.readByte();
                result |= (currentByte & 0x7F) << bytesRead++ * 7;
                if (bytesRead <= 5) continue;
                throw new RuntimeException("VarInt too big");
            } while ((currentByte & 0x80) == 128);
            return result;
        }

        @Override
        public void encode(ByteBuf out, Integer value) {
            while ((value & 0xFFFFFF80) != 0) {
                out.writeByte(value & 0x7F | 0x80);
                value = value >>> 7;
            }
            out.writeByte(value.intValue());
        }
    };
    public static final NetWorkCodec<OptionalInt> OPTIONAL_VAR_INTEGER = VAR_INTEGER.map(integer -> integer == 0 ? OptionalInt.empty() : OptionalInt.of(integer - 1), optionalInt -> optionalInt.isPresent() ? optionalInt.getAsInt() + 1 : 0);
    public static final NetWorkCodec<Long> LONG = new NetWorkCodec<Long>(){

        @Override
        public Long decode(ByteBuf in) {
            return in.readLong();
        }

        @Override
        public void encode(ByteBuf out, Long value) {
            out.writeLong(value.longValue());
        }
    };
    public static final NetWorkCodec<Long> VAR_LONG = new NetWorkCodec<Long>(){

        @Override
        public Long decode(ByteBuf in) {
            byte currentByte;
            long result = 0L;
            int bytesRead = 0;
            do {
                currentByte = in.readByte();
                result |= (long)(currentByte & 0x7F) << bytesRead++ * 7;
                if (bytesRead <= 10) continue;
                throw new RuntimeException("VarLong too big");
            } while ((currentByte & 0x80) == 128);
            return result;
        }

        @Override
        public void encode(ByteBuf out, Long value) {
            while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
                out.writeByte((int)(value & 0x7FL) | 0x80);
                value = value >>> 7;
            }
            out.writeByte(value.intValue());
        }
    };
    public static final NetWorkCodec<Float> FLOAT = new NetWorkCodec<Float>(){

        @Override
        public Float decode(ByteBuf in) {
            return Float.valueOf(in.readFloat());
        }

        @Override
        public void encode(ByteBuf out, Float value) {
            out.writeFloat(value.floatValue());
        }
    };
    public static final NetWorkCodec<Double> DOUBLE = new NetWorkCodec<Double>(){

        @Override
        public Double decode(ByteBuf in) {
            return in.readDouble();
        }

        @Override
        public void encode(ByteBuf out, Double value) {
            out.writeDouble(value.doubleValue());
        }
    };
    public static final NetWorkCodec<byte[]> BYTE_ARRAY = new NetWorkCodec<byte[]>(){

        @Override
        public byte[] decode(ByteBuf in) {
            int maxSize = in.readableBytes();
            int size = (Integer)VAR_INTEGER.decode(in);
            if (size > maxSize) {
                throw new DecoderException("ByteArray with size " + size + " is bigger than allowed " + maxSize);
            }
            byte[] bytes = new byte[size];
            in.readBytes(bytes);
            return bytes;
        }

        @Override
        public void encode(ByteBuf out, byte[] value) {
            VAR_INTEGER.encode(out, value.length);
            out.writeBytes(value);
        }
    };
    public static final NetWorkCodec<long[]> LONG_ARRAY = new NetWorkCodec<long[]>(){

        @Override
        public long[] decode(ByteBuf in) {
            int maxPossibleElements;
            int arrayLength = (Integer)VAR_INTEGER.decode(in);
            if (arrayLength > (maxPossibleElements = in.readableBytes() / 8)) {
                throw new DecoderException("LongArray with size " + arrayLength + " is bigger than allowed " + maxPossibleElements);
            }
            long[] longArray = new long[arrayLength];
            for (int i = 0; i < longArray.length; ++i) {
                longArray[i] = in.readLong();
            }
            return longArray;
        }

        @Override
        public void encode(ByteBuf out, long[] value) {
            VAR_INTEGER.encode(out, value.length);
            for (long element : value) {
                out.writeLong(element);
            }
        }
    };
    public static final NetWorkCodec<String> STRING_UTF8 = new NetWorkCodec<String>(){
        private static final int MAX_STRING_LENGTH = Short.MAX_VALUE;

        @Override
        public String decode(ByteBuf in) {
            int maxEncodedBytes = ByteBufUtil.utf8MaxBytes((int)Short.MAX_VALUE);
            int encodedLength = (Integer)VAR_INTEGER.decode(in);
            if (encodedLength > maxEncodedBytes) {
                throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + encodedLength + " > " + maxEncodedBytes + ")");
            }
            if (encodedLength < 0) {
                throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
            }
            int availableBytes = in.readableBytes();
            if (encodedLength > availableBytes) {
                throw new DecoderException("Not enough bytes in buffer, expected " + encodedLength + ", but got " + availableBytes);
            }
            String decodedString = in.toString(in.readerIndex(), encodedLength, StandardCharsets.UTF_8);
            in.readerIndex(in.readerIndex() + encodedLength);
            if (decodedString.length() > Short.MAX_VALUE) {
                throw new DecoderException("The received string length is longer than maximum allowed (" + decodedString.length() + " > 32767)");
            }
            return decodedString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void encode(ByteBuf out, String value) {
            if (value.length() > Short.MAX_VALUE) {
                throw new EncoderException("String too big (was " + value.length() + " characters, max 32767)");
            }
            int maxPossibleBytes = ByteBufUtil.utf8MaxBytes((CharSequence)value);
            ByteBuf tempBuffer = out.alloc().buffer(maxPossibleBytes);
            try {
                int actualEncodedBytes = ByteBufUtil.writeUtf8((ByteBuf)tempBuffer, (CharSequence)value);
                int maxAllowedBytes = ByteBufUtil.utf8MaxBytes((int)Short.MAX_VALUE);
                if (actualEncodedBytes > maxAllowedBytes) {
                    throw new EncoderException("String too big (was " + actualEncodedBytes + " bytes encoded, max " + maxAllowedBytes + ")");
                }
                VAR_INTEGER.encode(out, actualEncodedBytes);
                out.writeBytes(tempBuffer);
            }
            finally {
                tempBuffer.release();
            }
        }
    };
    public static final NetWorkCodec<Tag> TAG = new NetWorkCodec<Tag>(){

        @Override
        public Tag decode(ByteBuf in) {
            int initialIndex = in.readerIndex();
            byte marker = in.readByte();
            if (marker == 0) {
                return null;
            }
            in.readerIndex(initialIndex);
            try {
                return NBT.readUnnamedTag((DataInput)new ByteBufInputStream(in), false);
            }
            catch (IOException e) {
                throw new EncoderException("Failed to read NBT compound: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void encode(ByteBuf out, Tag value) {
            if (value == null) {
                out.writeByte(0);
            } else {
                try {
                    NBT.writeUnnamedTag(value, (DataOutput)new ByteBufOutputStream(out), false);
                }
                catch (IOException e) {
                    throw new EncoderException("Failed to write NBT compound: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    };
    public static final NetWorkCodec<CompoundTag> COMPOUND_TAG = TAG.map(tag -> {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return compoundTag;
        }
        throw new DecoderException("Not a compound tag: " + String.valueOf(tag));
    }, tag -> tag);
    public static final NetWorkCodec<Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new NetWorkCodec<Optional<CompoundTag>>(){

        @Override
        public Optional<CompoundTag> decode(ByteBuf in) {
            int initialIndex = in.readerIndex();
            byte marker = in.readByte();
            if (marker == 0) {
                return Optional.empty();
            }
            in.readerIndex(initialIndex);
            try {
                Tag tag = NBT.readUnnamedTag((DataInput)new ByteBufInputStream(in), false);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)tag;
                    return Optional.of(compoundTag);
                }
            }
            catch (IOException e) {
                throw new EncoderException("Failed to read NBT compound: " + e.getMessage(), (Throwable)e);
            }
            return Optional.empty();
        }

        @Override
        public void encode(ByteBuf out, Optional<CompoundTag> value) {
            CompoundTag compound = value.orElse(null);
            if (compound == null) {
                out.writeByte(0);
            } else {
                try {
                    NBT.writeUnnamedTag(compound, (DataOutput)new ByteBufOutputStream(out), false);
                }
                catch (IOException e) {
                    throw new EncoderException("Failed to write NBT compound: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    };
    public static final NetWorkCodec<Vector3f> VECTOR3F = new NetWorkCodec<Vector3f>(){

        @Override
        public Vector3f decode(ByteBuf in) {
            return new Vector3f(in.readFloat(), in.readFloat(), in.readFloat());
        }

        @Override
        public void encode(ByteBuf out, Vector3f value) {
            out.writeFloat(value.x());
            out.writeFloat(value.y());
            out.writeFloat(value.z());
        }
    };
    public static final NetWorkCodec<Quaternionf> QUATERNIONF = new NetWorkCodec<Quaternionf>(){

        @Override
        public Quaternionf decode(ByteBuf in) {
            return new Quaternionf(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
        }

        @Override
        public void encode(ByteBuf out, Quaternionf value) {
            out.writeFloat(value.x());
            out.writeFloat(value.y());
            out.writeFloat(value.z());
            out.writeFloat(value.w());
        }
    };
    public static final NetWorkCodec<Integer> CONTAINER_ID = VAR_INTEGER;
    public static final NetWorkCodec<Integer> RGB_COLOR = new NetWorkCodec<Integer>(){

        @Override
        public Integer decode(ByteBuf in) {
            return 0xFF000000 | in.readByte() & 0xFF0000 | in.readByte() & 0xFF00 | in.readByte() & 0xFF;
        }

        @Override
        public void encode(ByteBuf out, Integer value) {
            out.writeByte(value >> 16 & 0xFF);
            out.writeByte(value >> 8 & 0xFF);
            out.writeByte(value & 0xFF);
        }
    };
}

