/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.sound;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistries;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.sound.AbstractSoundManager;
import net.momirealms.craftengine.core.sound.JukeboxSong;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;

public class BukkitSoundManager
extends AbstractSoundManager {
    public BukkitSoundManager(CraftEngine plugin) {
        super(plugin);
        for (Object soundEvent : (Iterable)MBuiltInRegistries.SOUND_EVENT) {
            Object resourceLocation = FastNMS.INSTANCE.field$SoundEvent$location(soundEvent);
            VANILLA_SOUND_EVENTS.add(KeyUtils.resourceLocationToKey(resourceLocation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerSongs(Map<Key, JukeboxSong> songs) {
        if (songs.isEmpty()) {
            return;
        }
        Object registry = FastNMS.INSTANCE.method$RegistryAccess$lookupOrThrow(FastNMS.INSTANCE.registryAccess(), MRegistries.JUKEBOX_SONG);
        try {
            CoreReflections.field$MappedRegistry$frozen.set(registry, false);
            for (Map.Entry<Key, JukeboxSong> entry : songs.entrySet()) {
                Key id = entry.getKey();
                JukeboxSong jukeboxSong = entry.getValue();
                Object resourceLocation = KeyUtils.toResourceLocation(id);
                Object soundId = KeyUtils.toResourceLocation(jukeboxSong.sound());
                Object song = FastNMS.INSTANCE.method$Registry$getValue(registry, resourceLocation);
                Object soundEvent = VersionHelper.isOrAbove1_21_2() ? CoreReflections.constructor$SoundEvent.newInstance(soundId, Optional.of(Float.valueOf(jukeboxSong.range()))) : CoreReflections.constructor$SoundEvent.newInstance(soundId, Float.valueOf(jukeboxSong.range()), false);
                Object soundHolder = CoreReflections.method$Holder$direct.invoke(null, soundEvent);
                if (song != null) continue;
                song = CoreReflections.constructor$JukeboxSong.newInstance(soundHolder, ComponentUtils.adventureToMinecraft(jukeboxSong.description()), Float.valueOf(jukeboxSong.lengthInSeconds()), jukeboxSong.comparatorOutput());
                Object holder = CoreReflections.method$Registry$registerForHolder.invoke(null, registry, resourceLocation, song);
                CoreReflections.method$Holder$Reference$bindValue.invoke(holder, song);
                CoreReflections.field$Holder$Reference$tags.set(holder, Set.of());
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to register jukebox songs.", e);
        }
        finally {
            try {
                CoreReflections.field$MappedRegistry$frozen.set(registry, true);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }
}

