/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.world;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.injector.RecipeInjector;
import net.momirealms.craftengine.bukkit.plugin.injector.WorldStorageInjector;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.world.BukkitCEWorld;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.scheduler.SchedulerTask;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.SectionPos;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldManager;
import net.momirealms.craftengine.core.world.chunk.CEChunk;
import net.momirealms.craftengine.core.world.chunk.CESection;
import net.momirealms.craftengine.core.world.chunk.storage.DefaultStorageAdaptor;
import net.momirealms.craftengine.core.world.chunk.storage.StorageAdaptor;
import net.momirealms.craftengine.core.world.chunk.storage.WorldDataStorage;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitWorldManager
implements WorldManager,
Listener {
    private static BukkitWorldManager instance;
    private final BukkitCraftEngine plugin;
    private final Map<UUID, CEWorld> worlds;
    private CEWorld[] worldArray = new CEWorld[0];
    private final ReentrantReadWriteLock worldMapLock = new ReentrantReadWriteLock();
    private SchedulerTask tickTask;
    private UUID lastVisitedUUID;
    private CEWorld lastVisitedWorld;
    private StorageAdaptor storageAdaptor;
    private boolean isTicking = false;

    public BukkitWorldManager(BukkitCraftEngine plugin) {
        instance = this;
        this.plugin = plugin;
        this.worlds = new HashMap<UUID, CEWorld>();
        this.storageAdaptor = new DefaultStorageAdaptor();
    }

    @Override
    public void setStorageAdaptor(@NotNull StorageAdaptor storageAdaptor) {
        this.storageAdaptor = storageAdaptor;
    }

    public static BukkitWorldManager instance() {
        return instance;
    }

    public CEWorld getWorld(org.bukkit.World world) {
        return this.getWorld(world.getUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CEWorld getWorld(UUID uuid) {
        if (uuid.equals(this.lastVisitedUUID)) {
            return this.lastVisitedWorld;
        }
        this.worldMapLock.readLock().lock();
        try {
            CEWorld world = this.worlds.get(uuid);
            if (world != null) {
                this.lastVisitedUUID = uuid;
                this.lastVisitedWorld = world;
            }
            CEWorld cEWorld = world;
            return cEWorld;
        }
        finally {
            this.worldMapLock.readLock().unlock();
        }
    }

    private void resetWorldArray() {
        this.worldArray = this.worlds.values().toArray(new CEWorld[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin.javaPlugin());
        this.tickTask = this.plugin.scheduler().asyncRepeating(() -> {
            try {
                if (this.isTicking) {
                    return;
                }
                this.isTicking = true;
                for (CEWorld world : this.worldArray) {
                    world.tick();
                }
            }
            finally {
                this.isTicking = false;
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
        this.worldMapLock.writeLock().lock();
        try {
            for (org.bukkit.World world : Bukkit.getWorlds()) {
                try {
                    BukkitCEWorld ceWorld = new BukkitCEWorld((World)new BukkitWorld(world), this.storageAdaptor);
                    this.worlds.put(world.getUID(), ceWorld);
                    this.resetWorldArray();
                    for (Chunk chunk : world.getLoadedChunks()) {
                        this.handleChunkLoad(ceWorld, chunk);
                    }
                }
                catch (Exception e) {
                    CraftEngine.instance().logger().warn("Error loading world: " + world.getName(), e);
                }
            }
        }
        finally {
            this.worldMapLock.writeLock().unlock();
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        StorageAdaptor storageAdaptor = this.storageAdaptor;
        if (storageAdaptor instanceof Listener) {
            Listener listener = (Listener)storageAdaptor;
            HandlerList.unregisterAll((Listener)listener);
        }
        if (this.tickTask != null && !this.tickTask.cancelled()) {
            this.tickTask.cancel();
        }
        for (org.bukkit.World world : Bukkit.getWorlds()) {
            CEWorld ceWorld = this.getWorld(world.getUID());
            for (Chunk chunk : world.getLoadedChunks()) {
                this.handleChunkUnload(ceWorld, chunk);
            }
            try {
                ceWorld.worldDataStorage().close();
            }
            catch (IOException e) {
                this.plugin.logger().warn("Error unloading world: " + world.getName(), e);
            }
        }
        this.worlds.clear();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldLoadEvent event) {
        this.loadWorld(new BukkitWorld(event.getWorld()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadWorld(World world) {
        this.worldMapLock.writeLock().lock();
        try {
            if (this.worlds.containsKey(world.uuid())) {
                return;
            }
            BukkitCEWorld ceWorld = new BukkitCEWorld(world, this.storageAdaptor);
            this.worlds.put(world.uuid(), ceWorld);
            this.resetWorldArray();
            for (Chunk chunk : ((org.bukkit.World)world.platformWorld()).getLoadedChunks()) {
                this.handleChunkLoad(ceWorld, chunk);
            }
        }
        finally {
            this.worldMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadWorld(CEWorld world) {
        this.worldMapLock.writeLock().lock();
        try {
            if (this.worlds.containsKey(world.world().uuid())) {
                return;
            }
            this.worlds.put(world.world().uuid(), world);
            this.resetWorldArray();
            for (Chunk chunk : ((org.bukkit.World)world.world().platformWorld()).getLoadedChunks()) {
                this.handleChunkLoad(world, chunk);
            }
        }
        finally {
            this.worldMapLock.writeLock().unlock();
        }
    }

    @Override
    public CEWorld createWorld(World world, WorldDataStorage storage) {
        return new BukkitCEWorld(world, storage);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onWorldUnload(WorldUnloadEvent event) {
        this.unloadWorld(new BukkitWorld(event.getWorld()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onWorldSave(WorldSaveEvent event) {
        for (CEWorld world : this.worldArray) {
            world.save();
        }
    }

    @Override
    public void unloadWorld(World world) {
        CEWorld ceWorld;
        this.worldMapLock.writeLock().lock();
        try {
            ceWorld = this.worlds.remove(world.uuid());
            if (ceWorld == null) {
                return;
            }
            if (ceWorld == this.lastVisitedWorld) {
                this.lastVisitedWorld = null;
                this.lastVisitedUUID = null;
            }
            this.resetWorldArray();
        }
        finally {
            this.worldMapLock.writeLock().unlock();
        }
        for (Chunk chunk : ((org.bukkit.World)world.platformWorld()).getLoadedChunks()) {
            this.handleChunkUnload(ceWorld, chunk);
        }
        try {
            ceWorld.worldDataStorage().close();
        }
        catch (IOException e) {
            CraftEngine.instance().logger().warn("Failed to close world storage", e);
        }
    }

    @Override
    public <T> World wrap(T world) {
        if (world instanceof org.bukkit.World) {
            org.bukkit.World w = (org.bukkit.World)world;
            return new BukkitWorld(w);
        }
        throw new IllegalArgumentException(String.valueOf(world.getClass()) + " is not a Bukkit World");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onChunkLoad(ChunkLoadEvent event) {
        CEWorld world;
        this.worldMapLock.readLock().lock();
        try {
            world = this.worlds.get(event.getWorld().getUID());
            if (world == null) {
                return;
            }
        }
        finally {
            this.worldMapLock.readLock().unlock();
        }
        this.handleChunkLoad(world, event.getChunk());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onChunkUnload(ChunkUnloadEvent event) {
        CEWorld world;
        this.worldMapLock.readLock().lock();
        try {
            world = this.worlds.get(event.getWorld().getUID());
            if (world == null) {
                return;
            }
        }
        finally {
            this.worldMapLock.readLock().unlock();
        }
        this.handleChunkUnload(world, event.getChunk());
    }

    private void handleChunkUnload(CEWorld world, Chunk chunk) {
        ChunkPos pos = new ChunkPos(chunk.getX(), chunk.getZ());
        CEChunk ceChunk = world.getChunkAtIfLoaded(chunk.getX(), chunk.getZ());
        if (ceChunk != null) {
            if (ceChunk.dirty()) {
                try {
                    world.worldDataStorage().writeChunkAt(pos, ceChunk);
                    ceChunk.setDirty(false);
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to write chunk tag at " + chunk.getX() + " " + chunk.getZ(), e);
                }
            }
            boolean unsaved = false;
            CESection[] ceSections = ceChunk.sections();
            Object worldServer = FastNMS.INSTANCE.field$CraftChunk$worldServer(chunk);
            Object chunkSource = FastNMS.INSTANCE.method$ServerLevel$getChunkSource(worldServer);
            Object levelChunk = FastNMS.INSTANCE.method$ServerChunkCache$getChunkAtIfLoadedMainThread(chunkSource, chunk.getX(), chunk.getZ());
            Object[] sections = FastNMS.INSTANCE.method$ChunkAccess$getSections(levelChunk);
            for (int i = 0; i < ceSections.length; ++i) {
                CESection ceSection = ceSections[i];
                Object section = sections[i];
                WorldStorageInjector.uninjectLevelChunkSection(section);
                if (!Config.restoreVanillaBlocks() || ceSection.statesContainer().isEmpty()) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            ImmutableBlockState customState = ceSection.getBlockState(x, y, z);
                            if (customState.isEmpty() || customState.vanillaBlockState() == null) continue;
                            FastNMS.INSTANCE.method$LevelChunkSection$setBlockState(section, x, y, z, customState.vanillaBlockState().handle(), false);
                            unsaved = true;
                        }
                    }
                }
            }
            if (unsaved) {
                FastNMS.INSTANCE.method$LevelChunk$markUnsaved(levelChunk);
            }
            ceChunk.unload();
        }
    }

    private void handleChunkLoad(CEWorld ceWorld, Chunk chunk) {
        CEChunk ceChunk;
        ChunkPos pos = new ChunkPos(chunk.getX(), chunk.getZ());
        if (ceWorld.isChunkLoaded(pos.longKey)) {
            return;
        }
        try {
            ceChunk = ceWorld.worldDataStorage().readChunkAt(ceWorld, pos);
            try {
                CESection[] ceSections = ceChunk.sections();
                Object worldServer = FastNMS.INSTANCE.field$CraftChunk$worldServer(chunk);
                Object chunkSource = FastNMS.INSTANCE.method$ServerLevel$getChunkSource(worldServer);
                Object levelChunk = FastNMS.INSTANCE.method$ServerChunkCache$getChunkAtIfLoadedMainThread(chunkSource, chunk.getX(), chunk.getZ());
                Object[] sections = FastNMS.INSTANCE.method$ChunkAccess$getSections(levelChunk);
                for (int i = 0; i < ceSections.length; ++i) {
                    CESection ceSection = ceSections[i];
                    Object section = sections[i];
                    if (Config.syncCustomBlocks()) {
                        Object statesContainer = FastNMS.INSTANCE.field$LevelChunkSection$states(section);
                        Object data = CoreReflections.varHandle$PalettedContainer$data.get(statesContainer);
                        Object palette = CoreReflections.field$PalettedContainer$Data$palette.get(data);
                        boolean requiresSync = false;
                        if (CoreReflections.clazz$SingleValuePalette.isInstance(palette)) {
                            Object onlyBlockState = CoreReflections.field$SingleValuePalette$value.get(palette);
                            if (BlockStateUtils.isCustomBlock(onlyBlockState)) {
                                requiresSync = true;
                            }
                        } else if (CoreReflections.clazz$LinearPalette.isInstance(palette)) {
                            Object[] blockStates;
                            for (Object blockState : blockStates = (Object[])CoreReflections.field$LinearPalette$values.get(palette)) {
                                if (blockState == null || !BlockStateUtils.isCustomBlock(blockState)) continue;
                                requiresSync = true;
                                break;
                            }
                        } else if (CoreReflections.clazz$HashMapPalette.isInstance(palette)) {
                            Object[] blockStates;
                            Object biMap = CoreReflections.field$HashMapPalette$values.get(palette);
                            for (Object blockState : blockStates = (Object[])CoreReflections.field$CrudeIncrementalIntIdentityHashBiMap$keys.get(biMap)) {
                                if (blockState == null || !BlockStateUtils.isCustomBlock(blockState)) continue;
                                requiresSync = true;
                                break;
                            }
                        } else {
                            requiresSync = true;
                        }
                        if (requiresSync) {
                            for (int x = 0; x < 16; ++x) {
                                for (int z = 0; z < 16; ++z) {
                                    for (int y = 0; y < 16; ++y) {
                                        Object mcState = FastNMS.INSTANCE.method$LevelChunkSection$getBlockState(section, x, y, z);
                                        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(mcState);
                                        if (!optionalCustomState.isPresent()) continue;
                                        ceSection.setBlockState(x, y, z, optionalCustomState.get());
                                    }
                                }
                            }
                        }
                    }
                    if (Config.restoreCustomBlocks() && !ceSection.statesContainer().isEmpty()) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                for (int y = 0; y < 16; ++y) {
                                    ImmutableBlockState customState = ceSection.getBlockState(x, y, z);
                                    if (customState.isEmpty() || customState.customBlockState() == null) continue;
                                    FastNMS.INSTANCE.method$LevelChunkSection$setBlockState(section, x, y, z, customState.customBlockState().handle(), false);
                                }
                            }
                        }
                    }
                    int finalI = i;
                    WorldStorageInjector.injectLevelChunkSection(section, ceSection, ceChunk, new SectionPos(pos.x, ceChunk.sectionY(i), pos.z), injected -> {
                        sections[finalI] = injected;
                    });
                }
                if (Config.enableRecipeSystem()) {
                    Map blockEntities = (Map)FastNMS.INSTANCE.field$ChunkAccess$blockEntities(levelChunk);
                    for (Object blockEntity : blockEntities.values()) {
                        RecipeInjector.injectCookingBlockEntity(blockEntity);
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                this.plugin.logger().warn("Failed to restore chunk at " + chunk.getX() + " " + chunk.getZ(), e);
                return;
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to read chunk tag at " + chunk.getX() + " " + chunk.getZ(), e);
            return;
        }
        ceChunk.load();
    }
}

