/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.core.block.BlockManager;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.pack.model.generation.AbstractModelGenerator;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockManager
extends AbstractModelGenerator
implements BlockManager {
    protected final Map<Key, CustomBlock> byId = new HashMap<Key, CustomBlock>();
    protected final List<Suggestion> cachedSuggestions = new ArrayList<Suggestion>();
    protected final Set<String> namespacesInUse = new HashSet<String>();
    protected final Map<Key, JsonElement> modBlockStates = new HashMap<Key, JsonElement>();
    protected final Map<Integer, JsonElement> tempVanillaBlockStateModels = new Int2ObjectOpenHashMap();
    protected final Map<Integer, Key> tempRegistryIdConflictMap = new Int2ObjectOpenHashMap();
    protected final Map<Integer, Integer> tempBlockAppearanceConvertor = new Int2IntOpenHashMap();
    protected final Map<Key, Map<String, JsonElement>> blockStateOverrides = new HashMap<Key, Map<String, JsonElement>>();
    protected final Map<Integer, List<Integer>> appearanceToRealState = new Int2ObjectOpenHashMap();
    protected Map<Integer, List<String>> clientBoundTags = Map.of();
    protected Map<Integer, List<String>> previousClientBoundTags = Map.of();

    protected AbstractBlockManager(CraftEngine plugin) {
        super(plugin);
    }

    @Override
    public void unload() {
        super.clearModelsToGenerate();
        this.clearCache();
        this.cachedSuggestions.clear();
        this.blockStateOverrides.clear();
        this.modBlockStates.clear();
        this.byId.clear();
        this.previousClientBoundTags = this.clientBoundTags;
        this.clientBoundTags = new HashMap<Integer, List<String>>();
        this.appearanceToRealState.clear();
    }

    @Override
    public void delayedLoad() {
        this.initSuggestions();
        this.clearCache();
        this.resendTags();
    }

    @Override
    public Map<Key, CustomBlock> blocks() {
        return Collections.unmodifiableMap(this.byId);
    }

    @Override
    public Optional<CustomBlock> blockById(Key id) {
        return Optional.ofNullable(this.byId.get(id));
    }

    @Override
    public void addBlock(Key id, CustomBlock customBlock) {
        this.byId.put(id, customBlock);
        if (Config.generateModAssets()) {
            for (ImmutableBlockState state : customBlock.variantProvider().states()) {
                this.modBlockStates.put(this.getBlockOwnerId(state.customBlockState()), this.tempVanillaBlockStateModels.get(state.vanillaBlockState().registryId()));
            }
        }
    }

    @Override
    public Map<Key, JsonElement> modBlockStates() {
        return Collections.unmodifiableMap(this.modBlockStates);
    }

    @Override
    public Map<Key, Map<String, JsonElement>> blockOverrides() {
        return Collections.unmodifiableMap(this.blockStateOverrides);
    }

    @Override
    public Collection<Suggestion> cachedSuggestions() {
        return Collections.unmodifiableCollection(this.cachedSuggestions);
    }

    public Set<String> namespacesInUse() {
        return Collections.unmodifiableSet(this.namespacesInUse);
    }

    protected void clearCache() {
        this.tempRegistryIdConflictMap.clear();
        this.tempBlockAppearanceConvertor.clear();
        this.tempVanillaBlockStateModels.clear();
    }

    protected void initSuggestions() {
        this.cachedSuggestions.clear();
        this.namespacesInUse.clear();
        HashSet<String> states = new HashSet<String>();
        for (CustomBlock block : this.byId.values()) {
            states.add(block.id().toString());
            this.namespacesInUse.add(block.id().namespace());
            for (ImmutableBlockState state : block.variantProvider().states()) {
                states.add(state.toString());
            }
        }
        for (String state : states) {
            this.cachedSuggestions.add(Suggestion.suggestion((String)state));
        }
    }

    @NotNull
    public List<Integer> appearanceToRealStates(int appearanceStateId) {
        return Optional.ofNullable(this.appearanceToRealState.get(appearanceStateId)).orElse(List.of());
    }

    protected abstract void resendTags();
}

