/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import net.momirealms.craftengine.core.block.DelegatingBlockState;

public interface BlockStateWrapper {
    public Object handle();

    public int registryId();

    public boolean isVanillaBlock();

    public static BlockStateWrapper vanilla(Object handle, int registryId) {
        return new VanillaBlockState(handle, registryId);
    }

    public static BlockStateWrapper custom(Object handle, int registryId) {
        return new CustomBlockState(handle, registryId);
    }

    public static BlockStateWrapper create(Object handle, int registryId, boolean isVanillaBlock) {
        if (isVanillaBlock) {
            return new VanillaBlockState(handle, registryId);
        }
        return new CustomBlockState(handle, registryId);
    }

    public static class VanillaBlockState
    extends AbstractBlockState {
        public VanillaBlockState(Object handle, int registryId) {
            super(handle, registryId);
        }

        @Override
        public boolean isVanillaBlock() {
            return true;
        }
    }

    public static class CustomBlockState
    extends AbstractBlockState {
        public CustomBlockState(Object handle, int registryId) {
            super(handle, registryId);
        }

        @Override
        public DelegatingBlockState handle() {
            return (DelegatingBlockState)super.handle();
        }

        @Override
        public boolean isVanillaBlock() {
            return false;
        }
    }

    public static abstract class AbstractBlockState
    implements BlockStateWrapper {
        protected final Object handle;
        protected final int registryId;

        public AbstractBlockState(Object handle, int registryId) {
            this.handle = handle;
            this.registryId = registryId;
        }

        @Override
        public Object handle() {
            return this.handle;
        }

        @Override
        public int registryId() {
            return this.registryId;
        }
    }
}

