/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.font;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.momirealms.craftengine.core.font.BitmapImage;
import net.momirealms.craftengine.core.util.Key;

public class Font {
    private final Key key;
    private final Map<Integer, BitmapImage> idToCodepoint = new LinkedHashMap<Integer, BitmapImage>();

    public Font(Key key) {
        this.key = key;
    }

    public boolean isCodepointInUse(int codepoint) {
        if (codepoint == 0) {
            return false;
        }
        return this.idToCodepoint.containsKey(codepoint);
    }

    public Collection<Integer> codepointsInUse() {
        return Collections.unmodifiableCollection(this.idToCodepoint.keySet());
    }

    public BitmapImage bitmapImageByCodepoint(int codepoint) {
        return this.idToCodepoint.get(codepoint);
    }

    public void addBitmapImage(int codepoint, BitmapImage image) {
        this.idToCodepoint.put(codepoint, image);
    }

    public Key key() {
        return this.key;
    }

    public Collection<BitmapImage> bitmapImages() {
        return this.idToCodepoint.values().stream().distinct().toList();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Font font = (Font)object;
        return this.key.equals(font.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

