/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.BuildableItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemSettings;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import org.jetbrains.annotations.NotNull;

public interface CustomItem<I>
extends BuildableItem<I> {
    @Override
    public Key id();

    public UniqueKey uniqueId();

    public Key material();

    public Key clientBoundMaterial();

    public ItemDataModifier<I>[] dataModifiers();

    public boolean hasClientBoundDataModifier();

    public ItemDataModifier<I>[] clientBoundDataModifiers();

    public ItemSettings settings();

    default public boolean is(Key tag) {
        return this.settings().tags().contains(tag);
    }

    default public Item<I> buildItem(Player player) {
        return this.buildItem(ItemBuildContext.of(player));
    }

    public Item<I> buildItem(ItemBuildContext var1);

    public void execute(PlayerOptionalContext var1, EventTrigger var2);

    @NotNull
    public List<ItemBehavior> behaviors();

    public static interface Builder<I> {
        public Builder<I> id(UniqueKey var1);

        public Builder<I> clientBoundMaterial(Key var1);

        public Builder<I> material(Key var1);

        public Builder<I> dataModifier(ItemDataModifier<I> var1);

        public Builder<I> dataModifiers(List<ItemDataModifier<I>> var1);

        public Builder<I> clientBoundDataModifier(ItemDataModifier<I> var1);

        public Builder<I> clientBoundDataModifiers(List<ItemDataModifier<I>> var1);

        public Builder<I> behavior(ItemBehavior var1);

        public Builder<I> behaviors(List<ItemBehavior> var1);

        public Builder<I> settings(ItemSettings var1);

        public Builder<I> events(Map<EventTrigger, List<Function<PlayerOptionalContext>>> var1);

        public CustomItem<I> build();
    }
}

