/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.item.AbstractItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemWrapper;
import net.momirealms.craftengine.core.item.data.Enchantment;
import net.momirealms.craftengine.core.item.data.FireworkExplosion;
import net.momirealms.craftengine.core.item.data.JukeboxPlayable;
import net.momirealms.craftengine.core.item.data.Trim;
import net.momirealms.craftengine.core.item.setting.EquipmentData;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.nbt.Tag;

public abstract class ItemFactory<W extends ItemWrapper<I>, I> {
    protected final CraftEngine plugin;

    protected ItemFactory(CraftEngine plugin) {
        this.plugin = plugin;
    }

    public Item<I> wrap(I item) {
        Objects.requireNonNull(item, "item");
        return new AbstractItem(this, this.wrapInternal(item));
    }

    protected abstract W mergeCopy(W var1, W var2);

    protected abstract void merge(W var1, W var2);

    protected abstract W wrapInternal(I var1);

    protected abstract Object getJavaTag(W var1, Object ... var2);

    protected abstract Tag getTag(W var1, Object ... var2);

    protected abstract void setTag(W var1, Object var2, Object ... var3);

    protected abstract boolean hasTag(W var1, Object ... var2);

    protected abstract boolean removeTag(W var1, Object ... var2);

    protected abstract void setComponent(W var1, Object var2, Object var3);

    protected abstract Object getExactComponent(W var1, Object var2);

    protected abstract Object getExactTag(W var1, Object ... var2);

    protected abstract void setExactComponent(W var1, Object var2, Object var3);

    protected abstract Object getJavaComponent(W var1, Object var2);

    protected abstract JsonElement getJsonComponent(W var1, Object var2);

    protected abstract Tag getSparrowNBTComponent(W var1, Object var2);

    protected abstract Object getNBTComponent(W var1, Object var2);

    protected abstract boolean hasComponent(W var1, Object var2);

    protected abstract void removeComponent(W var1, Object var2);

    protected abstract void resetComponent(W var1, Object var2);

    protected abstract I getItem(W var1);

    protected abstract void customModelData(W var1, Integer var2);

    protected abstract Optional<Integer> customModelData(W var1);

    protected abstract void customNameJson(W var1, String var2);

    protected abstract Optional<String> customNameJson(W var1);

    protected void customNameComponent(W item, Component component) {
        if (component != null) {
            this.customNameJson(item, AdventureHelper.componentToJson(component));
        } else {
            this.customNameJson(item, null);
        }
    }

    protected Optional<Component> customNameComponent(W item) {
        return this.customNameJson(item).map(AdventureHelper::jsonToComponent);
    }

    protected abstract void itemNameJson(W var1, String var2);

    protected abstract Optional<String> itemNameJson(W var1);

    protected void itemNameComponent(W item, Component component) {
        if (component != null) {
            this.itemNameJson(item, AdventureHelper.componentToJson(component));
        } else {
            this.itemNameJson(item, null);
        }
    }

    protected Optional<Component> itemNameComponent(W item) {
        return this.itemNameJson(item).map(AdventureHelper::jsonToComponent);
    }

    protected abstract Optional<List<String>> loreJson(W var1);

    protected abstract void loreJson(W var1, List<String> var2);

    protected void loreComponent(W item, List<Component> component) {
        if (component != null && !component.isEmpty()) {
            this.loreJson(item, component.stream().map(AdventureHelper::componentToJson).collect(Collectors.toList()));
        } else {
            this.loreJson(item, null);
        }
    }

    protected Optional<List<Component>> loreComponent(W item) {
        return this.loreJson(item).map(list -> list.stream().map(AdventureHelper::jsonToComponent).toList());
    }

    protected abstract void skull(W var1, String var2);

    protected abstract boolean unbreakable(W var1);

    protected abstract void unbreakable(W var1, boolean var2);

    protected abstract Optional<Boolean> glint(W var1);

    protected abstract void glint(W var1, Boolean var2);

    protected abstract Optional<Integer> damage(W var1);

    protected abstract void damage(W var1, Integer var2);

    protected abstract Optional<Integer> dyedColor(W var1);

    protected abstract void dyedColor(W var1, Integer var2);

    protected abstract int maxDamage(W var1);

    protected abstract void maxDamage(W var1, Integer var2);

    protected abstract void enchantments(W var1, List<Enchantment> var2);

    protected abstract void storedEnchantments(W var1, List<Enchantment> var2);

    protected abstract Optional<Enchantment> getEnchantment(W var1, Key var2);

    protected abstract void itemFlags(W var1, List<String> var2);

    protected abstract Key id(W var1);

    protected abstract Optional<Key> customId(W var1);

    protected abstract void customId(W var1, Key var2);

    protected abstract Key vanillaId(W var1);

    protected abstract int maxStackSize(W var1);

    protected abstract void maxStackSize(W var1, Integer var2);

    protected abstract boolean is(W var1, Key var2);

    protected abstract boolean isBlockItem(W var1);

    protected abstract void repairCost(W var1, Integer var2);

    protected abstract Optional<Integer> repairCost(W var1);

    protected abstract void trim(W var1, Trim var2);

    protected abstract Optional<Trim> trim(W var1);

    protected abstract void tooltipStyle(W var1, String var2);

    protected abstract Optional<String> tooltipStyle(W var1);

    protected abstract void jukeboxSong(W var1, JukeboxPlayable var2);

    protected abstract Optional<JukeboxPlayable> jukeboxSong(W var1);

    protected abstract void itemModel(W var1, String var2);

    protected abstract Optional<String> itemModel(W var1);

    protected abstract void equippable(W var1, EquipmentData var2);

    protected abstract Optional<EquipmentData> equippable(W var1);

    protected abstract void fireworkExplosion(W var1, FireworkExplosion var2);

    protected abstract Optional<FireworkExplosion> fireworkExplosion(W var1);

    protected abstract byte[] toByteArray(W var1);

    protected abstract void setJavaComponent(W var1, Object var2, Object var3);

    protected abstract void setJsonComponent(W var1, Object var2, JsonElement var3);

    protected abstract void setNBTComponent(W var1, Object var2, Tag var3);

    protected abstract W transmuteCopy(W var1, Key var2, int var3);

    protected abstract W unsafeTransmuteCopy(W var1, Object var2, int var3);

    protected abstract boolean isEmpty(W var1);

    protected abstract UniqueKey recipeIngredientID(W var1);
}

