/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class ComponentModifier<I>
implements ItemDataModifier<I> {
    private final List<Pair<Key, Tag>> arguments;
    private CompoundTag customData = null;

    public ComponentModifier(Map<String, Object> arguments) {
        ArrayList<Pair<Key, Tag>> pairs = new ArrayList<Pair<Key, Tag>>(arguments.size());
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            Key key = Key.of(entry.getKey());
            if (key.equals(ComponentKeys.CUSTOM_DATA)) {
                this.customData = (CompoundTag)this.parseValue(entry.getValue());
                continue;
            }
            pairs.add(new Pair<Key, Tag>(key, this.parseValue(entry.getValue())));
        }
        this.arguments = pairs;
    }

    public List<Pair<Key, Tag>> arguments() {
        return this.arguments;
    }

    private Tag parseValue(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (string.startsWith("(json) ")) {
                return CraftEngine.instance().platform().jsonToSparrowNBT((JsonElement)GsonHelper.get().fromJson(string.substring("(json) ".length()), JsonElement.class));
            }
            if (string.startsWith("(snbt) ")) {
                return CraftEngine.instance().platform().snbtToSparrowNBT(string.substring("(snbt) ".length()));
            }
        }
        return CraftEngine.instance().platform().javaToSparrowNBT(value);
    }

    @Override
    public String name() {
        return "components";
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        for (Pair<Key, Tag> entry : this.arguments) {
            item.setNBTComponent(entry.left(), entry.right());
        }
        if (this.customData != null) {
            CompoundTag tag = (CompoundTag)item.getTag(ComponentKeys.CUSTOM_DATA);
            if (tag != null) {
                for (Map.Entry<String, Tag> entry : this.customData.entrySet()) {
                    tag.put(entry.getKey(), entry.getValue());
                }
                item.setComponent(ComponentKeys.CUSTOM_DATA, tag);
            } else {
                item.setComponent(ComponentKeys.CUSTOM_DATA, this.customData);
            }
        }
        return item;
    }

    @Override
    public Item<I> prepareNetworkItem(Item<I> item, ItemBuildContext context, CompoundTag networkData) {
        for (Pair<Key, Tag> entry : this.arguments) {
            Tag previous = item.getSparrowNBTComponent(entry.left());
            if (previous != null) {
                networkData.put(entry.left().asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
                continue;
            }
            networkData.put(entry.left().asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
        }
        return item;
    }
}

