/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class HideTooltipModifier<I>
implements ItemDataModifier<I> {
    public static final Map<Key, Integer> TO_LEGACY;
    private final List<Key> components;
    private final Applier<I> applier;

    public HideTooltipModifier(List<Key> components) {
        this.components = components;
        if (VersionHelper.isOrAbove1_21_5()) {
            this.applier = new ModernApplier<I>(components);
        } else if (VersionHelper.isOrAbove1_20_5()) {
            if (components.isEmpty()) {
                this.applier = new DummyApplier<I>();
            } else if (components.size() == 1) {
                this.applier = new SemiModernApplier(components.getFirst());
            } else {
                ArrayList appliers = new ArrayList();
                for (Key key : components) {
                    appliers.add(new SemiModernApplier(key));
                }
                this.applier = new CompoundApplier(appliers);
            }
        } else {
            this.applier = new LegacyApplier<I>(components);
        }
    }

    public List<Key> components() {
        return this.components;
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        this.applier.apply(item);
        return item;
    }

    @Override
    public Item<I> prepareNetworkItem(Item<I> item, ItemBuildContext context, CompoundTag networkData) {
        if (VersionHelper.isOrAbove1_21_5()) {
            Tag previous = item.getSparrowNBTComponent(ComponentKeys.TOOLTIP_DISPLAY);
            if (previous != null) {
                networkData.put(ComponentKeys.TOOLTIP_DISPLAY.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
            } else {
                networkData.put(ComponentKeys.TOOLTIP_DISPLAY.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
            }
        } else if (VersionHelper.isOrAbove1_20_5()) {
            for (Key component : this.components) {
                Tag previous = item.getSparrowNBTComponent(component);
                if (previous != null) {
                    networkData.put(component.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
                    continue;
                }
                networkData.put(component.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
            }
        } else {
            Tag previous = item.getTag("HideFlags");
            if (previous != null) {
                networkData.put("HideFlags", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
            } else {
                networkData.put("HideFlags", NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
            }
        }
        return item;
    }

    @Override
    public String name() {
        return "hide-tooltip";
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ComponentKeys.ENCHANTMENTS, (Object)1);
        builder.put((Object)ComponentKeys.ATTRIBUTE_MODIFIERS, (Object)2);
        builder.put((Object)ComponentKeys.UNBREAKABLE, (Object)4);
        builder.put((Object)ComponentKeys.CAN_BREAK, (Object)8);
        builder.put((Object)ComponentKeys.CAN_PLACE_ON, (Object)16);
        builder.put((Object)ComponentKeys.STORED_ENCHANTMENTS, (Object)32);
        builder.put((Object)ComponentKeys.POTION_CONTENTS, (Object)32);
        builder.put((Object)ComponentKeys.WRITTEN_BOOK_CONTENT, (Object)32);
        builder.put((Object)ComponentKeys.FIREWORKS, (Object)32);
        builder.put((Object)ComponentKeys.FIREWORK_EXPLOSION, (Object)32);
        builder.put((Object)ComponentKeys.BUNDLE_CONTENTS, (Object)32);
        builder.put((Object)ComponentKeys.MAP_ID, (Object)32);
        builder.put((Object)ComponentKeys.MAP_COLOR, (Object)32);
        builder.put((Object)ComponentKeys.MAP_DECORATIONS, (Object)32);
        builder.put((Object)ComponentKeys.DYED_COLOR, (Object)64);
        builder.put((Object)ComponentKeys.TRIM, (Object)128);
        TO_LEGACY = builder.build();
    }

    public static class ModernApplier<W>
    implements Applier<W> {
        private final List<String> components;

        public ModernApplier(List<Key> components) {
            this.components = components.stream().map(Key::toString).collect(Collectors.toList());
        }

        public List<String> components() {
            return this.components;
        }

        @Override
        public void apply(Item<W> item) {
            Map<String, Object> data = MiscUtils.castToMap(item.getJavaComponent(ComponentKeys.TOOLTIP_DISPLAY), true);
            if (data == null) {
                item.setJavaComponent(ComponentKeys.TOOLTIP_DISPLAY, Map.of("hidden_components", this.components));
            } else {
                Object object = data.get("hidden_components");
                if (object instanceof List) {
                    List list = (List)object;
                    List<String> hiddenComponents = list.stream().map(Object::toString).toList();
                    List mergedComponents = Stream.concat(hiddenComponents.stream(), this.components.stream()).distinct().toList();
                    HashMap<String, Object> newData = new HashMap<String, Object>(data);
                    newData.put("hidden_components", mergedComponents);
                    item.setJavaComponent(ComponentKeys.TOOLTIP_DISPLAY, newData);
                } else {
                    HashMap<String, Object> newData = new HashMap<String, Object>(data);
                    newData.put("hidden_components", this.components);
                    item.setJavaComponent(ComponentKeys.TOOLTIP_DISPLAY, newData);
                }
            }
        }
    }

    public static interface Applier<I> {
        public void apply(Item<I> var1);
    }

    public static class DummyApplier<T>
    implements Applier<T> {
        @Override
        public void apply(Item<T> item) {
        }
    }

    public static class SemiModernApplier<I>
    implements Applier<I> {
        private final Key component;

        public SemiModernApplier(Key component) {
            this.component = component;
        }

        @Override
        public void apply(Item<I> item) {
            Tag previous = item.getSparrowNBTComponent(this.component);
            if (previous instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)previous;
                compoundTag.putBoolean("show_in_tooltip", false);
                item.setNBTComponent(this.component, compoundTag);
            } else {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.putBoolean("show_in_tooltip", false);
                item.setNBTComponent(this.component, compoundTag);
            }
        }
    }

    public record CompoundApplier<I>(List<Applier<I>> appliers) implements Applier<I>
    {
        @Override
        public void apply(Item<I> item) {
            for (Applier<I> applier : this.appliers) {
                applier.apply(item);
            }
        }
    }

    public static class LegacyApplier<W>
    implements Applier<W> {
        private final int legacyValue;

        public LegacyApplier(List<Key> components) {
            int i = 0;
            for (Key key : components) {
                Integer flag = TO_LEGACY.get(key);
                if (flag == null) continue;
                i += flag.intValue();
            }
            this.legacyValue = i;
        }

        public int legacyValue() {
            return this.legacyValue;
        }

        @Override
        public void apply(Item<W> item) {
            Integer previousFlags = (Integer)item.getJavaTag("HideFlags");
            if (previousFlags != null) {
                item.setTag(this.legacyValue | previousFlags, "HideFlags");
            } else {
                item.setTag(this.legacyValue, "HideFlags");
            }
        }
    }
}

