/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.Map;
import java.util.Set;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeFactory;
import net.momirealms.craftengine.core.item.recipe.CookingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CustomCookingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomRecipeResult;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.UniqueKey;
import org.jetbrains.annotations.NotNull;

public class CustomBlastingRecipe<T>
extends CustomCookingRecipe<T> {
    public static final Factory<?> FACTORY = new Factory();

    public CustomBlastingRecipe(Key id, CookingRecipeCategory category, String group, Ingredient<T> ingredient, int cookingTime, float experience, CustomRecipeResult<T> result) {
        super(id, category, group, ingredient, cookingTime, experience, result);
    }

    @Override
    @NotNull
    public Key type() {
        return RecipeTypes.BLASTING;
    }

    public static class Factory<A>
    extends AbstractRecipeFactory<A> {
        @Override
        public Recipe<A> create(Key id, Map<String, Object> arguments) {
            String group = arguments.containsKey("group") ? arguments.get("group").toString() : null;
            int cookingTime = ResourceConfigUtils.getAsInt(arguments.getOrDefault("time", 80), "time");
            float experience = ResourceConfigUtils.getAsFloat(arguments.getOrDefault("experience", Float.valueOf(0.0f)), "experience");
            Set<UniqueKey> holders = this.ingredientHolders(arguments);
            return new CustomBlastingRecipe(id, this.cookingRecipeCategory(arguments), group, Ingredient.of(holders), cookingTime, experience, this.parseResult(arguments));
        }
    }
}

