/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomRecipeResult;
import net.momirealms.craftengine.core.item.recipe.FixedResultRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeFactory;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.input.BrewingInput;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.NotNull;

public class CustomBrewingRecipe<T>
implements FixedResultRecipe<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final Key id;
    private final Ingredient<T> container;
    private final Ingredient<T> ingredient;
    private final CustomRecipeResult<T> result;

    public CustomBrewingRecipe(@NotNull Key id, @NotNull Ingredient<T> container, @NotNull Ingredient<T> ingredient, @NotNull CustomRecipeResult<T> result) {
        this.id = id;
        this.container = container;
        this.ingredient = ingredient;
        this.result = result;
    }

    @Override
    public CustomRecipeResult<T> result() {
        return this.result;
    }

    @Override
    public T result(ItemBuildContext context) {
        return this.result.buildItemStack(context);
    }

    @Override
    public boolean matches(RecipeInput input) {
        BrewingInput brewingInput = (BrewingInput)input;
        return this.container.test(brewingInput.container()) && this.ingredient.test(brewingInput.ingredient());
    }

    @Override
    public T assemble(RecipeInput input, ItemBuildContext context) {
        return this.result(context);
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        ArrayList<Ingredient<T>> ingredients = new ArrayList<Ingredient<T>>();
        ingredients.add(this.container);
        ingredients.add(this.ingredient);
        return ingredients;
    }

    @Override
    @NotNull
    public Key type() {
        return RecipeTypes.BREWING;
    }

    @NotNull
    public Ingredient<T> container() {
        return this.container;
    }

    @NotNull
    public Ingredient<T> ingredient() {
        return this.ingredient;
    }

    @Override
    public Key id() {
        return this.id;
    }

    public static class Factory<A>
    implements RecipeFactory<A> {
        @Override
        public Recipe<A> create(Key id, Map<String, Object> arguments) {
            List<String> container = MiscUtils.getAsStringList(arguments.get("container"));
            if (container.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.brewing.missing_container", new String[0]);
            }
            List<String> ingredient = MiscUtils.getAsStringList(arguments.get("ingredient"));
            if (ingredient.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.brewing.missing_ingredient", new String[0]);
            }
            return new CustomBrewingRecipe(id, ResourceConfigUtils.requireNonNullOrThrow(this.toIngredient(container), "warning.config.recipe.brewing.missing_container"), ResourceConfigUtils.requireNonNullOrThrow(this.toIngredient(ingredient), "warning.config.recipe.brewing.missing_ingredient"), this.parseResult(arguments));
        }
    }
}

