/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeFactory;
import net.momirealms.craftengine.core.item.recipe.CraftingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CustomCraftingTableRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomRecipeResult;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.UniqueKey;
import org.jetbrains.annotations.NotNull;

public class CustomShapedRecipe<T>
extends CustomCraftingTableRecipe<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final ParsedPattern<T> parsedPattern;
    private final Pattern<T> pattern;

    public CustomShapedRecipe(Key id, CraftingRecipeCategory category, String group, Pattern<T> pattern, CustomRecipeResult<T> result) {
        super(id, category, group, result);
        this.pattern = pattern;
        this.parsedPattern = pattern.parse();
    }

    public ParsedPattern<T> parsedPattern() {
        return this.parsedPattern;
    }

    @Override
    public boolean matches(RecipeInput input) {
        return this.parsedPattern.matches((CraftingInput)input);
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        return new ArrayList<Ingredient<T>>(this.pattern.ingredients().values());
    }

    @Override
    @NotNull
    public Key type() {
        return RecipeTypes.SHAPED;
    }

    public Pattern<T> pattern() {
        return this.pattern;
    }

    public static <T> List<Optional<Ingredient<T>>> toIngredientList(String[] pattern, Map<Character, Ingredient<T>> ingredients) {
        String[] shrunkPattern;
        ArrayList<Optional<Ingredient<T>>> result = new ArrayList<Optional<Ingredient<T>>>();
        for (String pa : shrunkPattern = CustomShapedRecipe.shrink(pattern)) {
            for (int j = 0; j < pa.length(); ++j) {
                char ch = pa.charAt(j);
                if (ch == ' ') {
                    result.add(Optional.empty());
                    continue;
                }
                Optional<Ingredient<T>> ingredient = Optional.ofNullable(ingredients.get(Character.valueOf(ch)));
                if (ingredient.isEmpty()) {
                    throw new IllegalArgumentException("Invalid ingredient: " + ch);
                }
                result.add(ingredient);
            }
        }
        return result;
    }

    public static String[] shrink(String[] patterns) {
        int minStart = Integer.MAX_VALUE;
        int maxEnd = 0;
        int leadingEmptyPatterns = 0;
        int consecutiveEmptyPatterns = 0;
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            minStart = Math.min(minStart, CustomShapedRecipe.firstNonSpace(pattern));
            int patternEnd = CustomShapedRecipe.lastNonSpace(pattern);
            maxEnd = Math.max(maxEnd, patternEnd);
            if (patternEnd < 0) {
                if (leadingEmptyPatterns == i) {
                    ++leadingEmptyPatterns;
                }
                ++consecutiveEmptyPatterns;
                continue;
            }
            consecutiveEmptyPatterns = 0;
        }
        if (patterns.length == consecutiveEmptyPatterns) {
            return new String[0];
        }
        String[] result = new String[patterns.length - consecutiveEmptyPatterns - leadingEmptyPatterns];
        for (int j = 0; j < result.length; ++j) {
            result[j] = patterns[j + leadingEmptyPatterns].substring(minStart, maxEnd + 1);
        }
        return result;
    }

    private static int firstNonSpace(String line) {
        int index;
        for (index = 0; index < line.length() && line.charAt(index) == ' '; ++index) {
        }
        return index;
    }

    private static int lastNonSpace(String line) {
        int index;
        for (index = line.length() - 1; index >= 0 && line.charAt(index) == ' '; --index) {
        }
        return index;
    }

    public record Pattern<T>(String[] pattern, Map<Character, Ingredient<T>> ingredients) {
        public ParsedPattern<T> parse() {
            String[] shrunk = CustomShapedRecipe.shrink(this.pattern);
            return new ParsedPattern<T>(shrunk[0].length(), shrunk.length, CustomShapedRecipe.toIngredientList(shrunk, this.ingredients));
        }
    }

    public static class ParsedPattern<T> {
        private final int width;
        private final int height;
        private final List<Optional<Ingredient<T>>> ingredients;
        private final int ingredientCount;
        private final boolean symmetrical;

        public ParsedPattern(int width, int height, List<Optional<Ingredient<T>>> ingredients) {
            this.height = height;
            this.width = width;
            this.ingredientCount = (int)ingredients.stream().flatMap(Optional::stream).count();
            this.symmetrical = ParsedPattern.isSymmetrical(width, height, ingredients);
            this.ingredients = ingredients;
        }

        public List<Optional<Ingredient<T>>> ingredients() {
            return this.ingredients;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public boolean matches(CraftingInput<T> input) {
            if (input.ingredientCount() == this.ingredientCount && input.width() == this.width && input.height() == this.height) {
                if (!this.symmetrical && this.matches(input, true)) {
                    return true;
                }
                return this.matches(input, false);
            }
            return false;
        }

        private boolean matches(CraftingInput<T> input, boolean mirrored) {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    UniqueIdItem<T> itemStack;
                    Optional<Ingredient<Object>> optional = mirrored ? this.ingredients.get(this.width - j - 1 + i * this.width) : this.ingredients.get(j + i * this.width);
                    if (Ingredient.isInstance(optional, itemStack = input.getItem(j, i))) continue;
                    return false;
                }
            }
            return true;
        }

        private static <T> boolean isSymmetrical(int width, int height, List<T> list) {
            if (width != 1) {
                int i = width / 2;
                for (int j = 0; j < height; ++j) {
                    for (int k = 0; k < i; ++k) {
                        T o2;
                        int l = width - 1 - k;
                        T o1 = list.get(k + j * width);
                        if (o1.equals(o2 = list.get(l + j * width))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static class Factory<A>
    extends AbstractRecipeFactory<A> {
        @Override
        public Recipe<A> create(Key id, Map<String, Object> arguments) {
            List<String> pattern = MiscUtils.getAsStringList(arguments.get("pattern"));
            if (pattern.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.shaped.missing_pattern", new String[0]);
            }
            if (!this.validatePattern(pattern)) {
                throw new LocalizedResourceConfigException("warning.config.recipe.shaped.invalid_pattern", pattern.toString());
            }
            Object ingredientObj = this.getIngredientOrThrow(arguments);
            String group = arguments.containsKey("group") ? arguments.get("group").toString() : null;
            HashMap ingredients = new HashMap();
            for (Map.Entry<String, Object> entry : MiscUtils.castToMap(ingredientObj, false).entrySet()) {
                String key = entry.getKey();
                if (key.length() != 1) {
                    throw new LocalizedResourceConfigException("warning.config.recipe.shaped.invalid_symbol", key);
                }
                char ch = key.charAt(0);
                List<String> items = MiscUtils.getAsStringList(entry.getValue());
                HashSet<UniqueKey> holders = new HashSet<UniqueKey>();
                for (String item : items) {
                    if (item.charAt(0) == '#') {
                        holders.addAll(CraftEngine.instance().itemManager().tagToItems(Key.of(item.substring(1))));
                        continue;
                    }
                    holders.add(UniqueKey.create(Key.of(item)));
                }
                ingredients.put(Character.valueOf(ch), Ingredient.of(holders));
            }
            return new CustomShapedRecipe(id, this.craftingRecipeCategory(arguments), group, new Pattern(pattern.toArray(new String[0]), ingredients), this.parseResult(arguments));
        }

        private boolean validatePattern(List<String> pattern) {
            String first = pattern.get(0);
            int length = first.length();
            for (String s : pattern) {
                if (s.length() != length) {
                    return false;
                }
                if (s.length() <= 3) continue;
                return false;
            }
            return pattern.size() <= 3;
        }
    }
}

