/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomRecipeResult;
import net.momirealms.craftengine.core.item.recipe.FixedResultRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeFactory;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.input.SmithingInput;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;
import net.momirealms.craftengine.core.util.TriConsumer;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSmithingTransformRecipe<T>
implements FixedResultRecipe<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final Key id;
    private final CustomRecipeResult<T> result;
    private final Ingredient<T> base;
    private final Ingredient<T> template;
    private final Ingredient<T> addition;
    private final boolean mergeComponents;
    private final List<ItemDataProcessor> processors;

    public CustomSmithingTransformRecipe(Key id, @Nullable Ingredient<T> base, @Nullable Ingredient<T> template, @Nullable Ingredient<T> addition, CustomRecipeResult<T> result, boolean mergeComponents, List<ItemDataProcessor> processors) {
        this.id = id;
        this.result = result;
        this.base = base;
        this.template = template;
        this.addition = addition;
        this.processors = processors;
        this.mergeComponents = mergeComponents;
    }

    @Override
    public boolean matches(RecipeInput input) {
        SmithingInput smithingInput = (SmithingInput)input;
        return this.checkIngredient(this.base, smithingInput.base()) && this.checkIngredient(this.template, smithingInput.template()) && this.checkIngredient(this.addition, smithingInput.addition());
    }

    private boolean checkIngredient(Ingredient<T> ingredient, UniqueIdItem<T> item) {
        if (ingredient != null) {
            if (item == null || item.isEmpty()) {
                return false;
            }
            return ingredient.test(item);
        }
        return item == null || item.isEmpty();
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        ArrayList<Ingredient<T>> ingredients = new ArrayList<Ingredient<T>>();
        ingredients.add(this.base);
        if (this.template != null) {
            ingredients.add(this.template);
        }
        if (this.addition != null) {
            ingredients.add(this.addition);
        }
        return ingredients;
    }

    @Override
    @NotNull
    public Key type() {
        return RecipeTypes.SMITHING_TRANSFORM;
    }

    @Override
    public Key id() {
        return this.id;
    }

    @Override
    @Nullable
    public T result(ItemBuildContext context) {
        return this.result.buildItemStack(context);
    }

    @Override
    public T assemble(RecipeInput input, ItemBuildContext context) {
        Item wrappedResult;
        SmithingInput smithingInput = (SmithingInput)input;
        Item base = smithingInput.base().item();
        T result = this.result(context);
        Item finalResult = wrappedResult = CraftEngine.instance().itemManager().wrap(result);
        if (this.mergeComponents) {
            finalResult = base.mergeCopy(wrappedResult);
        }
        for (ItemDataProcessor processor : this.processors) {
            processor.accept(base, wrappedResult, finalResult);
        }
        return finalResult.getItem();
    }

    @Override
    public CustomRecipeResult<T> result() {
        return this.result;
    }

    @Nullable
    public Ingredient<T> base() {
        return this.base;
    }

    @Nullable
    public Ingredient<T> template() {
        return this.template;
    }

    @Nullable
    public Ingredient<T> addition() {
        return this.addition;
    }

    public static interface ItemDataProcessor
    extends TriConsumer<Item<?>, Item<?>, Item<?>> {
        public Key type();

        public static interface ProcessorFactory {
            public ItemDataProcessor create(Map<String, Object> var1);
        }
    }

    public static class Factory<A>
    implements RecipeFactory<A> {
        @Override
        public Recipe<A> create(Key id, Map<String, Object> arguments) {
            List<String> base = MiscUtils.getAsStringList(arguments.get("base"));
            if (base.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.smithing_transform.missing_base", new String[0]);
            }
            List<String> addition = MiscUtils.getAsStringList(arguments.get("addition"));
            List<String> template = MiscUtils.getAsStringList(arguments.get("template-type"));
            boolean mergeComponents = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("merge-components", true), "merge-components");
            List<Map<String, Object>> processors = arguments.getOrDefault("post-processors", List.of());
            return new CustomSmithingTransformRecipe(id, this.toIngredient(base), this.toIngredient(template), this.toIngredient(addition), this.parseResult(arguments), mergeComponents, ItemDataProcessors.fromMapList(processors));
        }
    }

    public static class KeepTags
    implements ItemDataProcessor {
        public static final Factory FACTORY = new Factory();
        private final List<String[]> tags;

        public KeepTags(List<String[]> tags) {
            this.tags = tags;
        }

        @Override
        public void accept(Item<?> item1, Item<?> item2, Item<?> item3) {
            for (String[] tag : this.tags) {
                Object tagObj = item1.getJavaTag(tag);
                if (tagObj == null) continue;
                item3.setTag(tagObj, tag);
            }
        }

        @Override
        public Key type() {
            return ItemDataProcessors.KEEP_TAGS;
        }

        public static class Factory
        implements ItemDataProcessor.ProcessorFactory {
            @Override
            public ItemDataProcessor create(Map<String, Object> arguments) {
                Object tagsObj = arguments.get("tags");
                if (tagsObj == null) {
                    throw new LocalizedResourceConfigException("warning.config.recipe.smithing_transform.post_processor.keep_component.missing_tags", new String[0]);
                }
                List<String> tags = MiscUtils.getAsStringList(tagsObj);
                return new KeepTags(tags.stream().map(it -> it.split("\\.")).toList());
            }
        }
    }

    public static class KeepComponents
    implements ItemDataProcessor {
        public static final Factory FACTORY = new Factory();
        private final List<Key> components;

        public KeepComponents(List<Key> components) {
            this.components = components;
        }

        @Override
        public void accept(Item<?> item1, Item<?> item2, Item<?> item3) {
            for (Key component : this.components) {
                Object componentObj = item1.getExactComponent(component);
                if (componentObj == null) continue;
                item3.setComponent(component, componentObj);
            }
        }

        @Override
        public Key type() {
            return ItemDataProcessors.KEEP_COMPONENTS;
        }

        public static class Factory
        implements ItemDataProcessor.ProcessorFactory {
            @Override
            public ItemDataProcessor create(Map<String, Object> arguments) {
                Object componentsObj = arguments.get("components");
                if (componentsObj == null) {
                    throw new LocalizedResourceConfigException("warning.config.recipe.smithing_transform.post_processor.keep_component.missing_components", new String[0]);
                }
                List<String> components = MiscUtils.getAsStringList(componentsObj);
                return new KeepComponents(components.stream().map(Key::of).toList());
            }
        }
    }

    public static class ItemDataProcessors {
        public static final Key KEEP_COMPONENTS = Key.of("craftengine:keep_components");
        public static final Key KEEP_TAGS = Key.of("craftengine:keep_tags");

        public static List<ItemDataProcessor> fromMapList(List<Map<String, Object>> mapList) {
            if (mapList == null || mapList.isEmpty()) {
                return List.of();
            }
            ArrayList<ItemDataProcessor> functions = new ArrayList<ItemDataProcessor>();
            for (Map<String, Object> map : mapList) {
                functions.add(ItemDataProcessors.fromMap(map));
            }
            return functions;
        }

        public static ItemDataProcessor fromMap(Map<String, Object> map) {
            String type = (String)map.get("type");
            if (type == null) {
                throw new LocalizedResourceConfigException("warning.config.recipe.smithing_transform.post_processor.missing_type", new String[0]);
            }
            Key key = Key.withDefaultNamespace(type, "craftengine");
            ItemDataProcessor.ProcessorFactory factory = BuiltInRegistries.SMITHING_RESULT_PROCESSOR_FACTORY.getValue(key);
            if (factory == null) {
                throw new LocalizedResourceConfigException("warning.config.recipe.smithing_transform.post_processor.invalid_type", type);
            }
            return factory.create(map);
        }

        public static void register(Key key, ItemDataProcessor.ProcessorFactory factory) {
            ((WritableRegistry)BuiltInRegistries.SMITHING_RESULT_PROCESSOR_FACTORY).register(ResourceKey.create(Registries.SMITHING_RESULT_PROCESSOR_FACTORY.location(), key), factory);
        }

        static {
            if (VersionHelper.isOrAbove1_20_5()) {
                ItemDataProcessors.register(KEEP_COMPONENTS, KeepComponents.FACTORY);
            } else {
                ItemDataProcessors.register(KEEP_TAGS, KeepTags.FACTORY);
            }
        }
    }
}

