/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeFactory;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.input.SmithingInput;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSmithingTrimRecipe<T>
implements Recipe<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final Key id;
    private final Ingredient<T> base;
    private final Ingredient<T> template;
    private final Ingredient<T> addition;
    @Nullable
    private final Key pattern;

    public CustomSmithingTrimRecipe(@NotNull Key id, @NotNull Ingredient<T> base, @NotNull Ingredient<T> template, @NotNull Ingredient<T> addition, @Nullable Key pattern) {
        this.id = id;
        this.base = base;
        this.template = template;
        this.addition = addition;
        this.pattern = pattern;
        if (pattern == null && VersionHelper.isOrAbove1_21_5()) {
            throw new IllegalStateException("SmithingTrimRecipe cannot have a null pattern on 1.21.5 and above.");
        }
    }

    @Override
    public T assemble(RecipeInput input, ItemBuildContext context) {
        SmithingInput smithingInput = (SmithingInput)input;
        Item processed = CraftEngine.instance().itemManager().applyTrim(smithingInput.base().item(), smithingInput.addition().item(), smithingInput.template().item(), this.pattern);
        return processed.getItem();
    }

    @Override
    public boolean matches(RecipeInput input) {
        SmithingInput smithingInput = (SmithingInput)input;
        return this.checkIngredient(this.base, smithingInput.base()) && this.checkIngredient(this.template, smithingInput.template()) && this.checkIngredient(this.addition, smithingInput.addition());
    }

    private boolean checkIngredient(Ingredient<T> ingredient, UniqueIdItem<T> item) {
        if (ingredient != null) {
            if (item == null || item.isEmpty()) {
                return false;
            }
            return ingredient.test(item);
        }
        return item == null || item.isEmpty();
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        ArrayList<Ingredient<T>> ingredients = new ArrayList<Ingredient<T>>();
        ingredients.add(this.base);
        ingredients.add(this.template);
        ingredients.add(this.addition);
        return ingredients;
    }

    @Override
    @NotNull
    public Key type() {
        return RecipeTypes.SMITHING_TRIM;
    }

    @Override
    public Key id() {
        return this.id;
    }

    @Nullable
    public Ingredient<T> base() {
        return this.base;
    }

    @Nullable
    public Ingredient<T> template() {
        return this.template;
    }

    @Nullable
    public Ingredient<T> addition() {
        return this.addition;
    }

    @Nullable
    public Key pattern() {
        return this.pattern;
    }

    public static class Factory<A>
    implements RecipeFactory<A> {
        @Override
        public Recipe<A> create(Key id, Map<String, Object> arguments) {
            List<String> base = MiscUtils.getAsStringList(arguments.get("base"));
            if (base.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.smithing_trim.missing_base", new String[0]);
            }
            List<String> addition = MiscUtils.getAsStringList(arguments.get("addition"));
            if (addition.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.smithing_trim.missing_addition", new String[0]);
            }
            List<String> template = MiscUtils.getAsStringList(arguments.get("template-type"));
            if (template.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.smithing_trim.missing_template_type", new String[0]);
            }
            Key pattern = VersionHelper.isOrAbove1_21_5() ? Key.of(ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("pattern"), "warning.config.recipe.smithing_trim.missing_pattern")) : null;
            return new CustomSmithingTrimRecipe(id, ResourceConfigUtils.requireNonNullOrThrow(this.toIngredient(base), "warning.config.recipe.smithing_trim.missing_base"), ResourceConfigUtils.requireNonNullOrThrow(this.toIngredient(template), "warning.config.recipe.smithing_trim.missing_template_type"), ResourceConfigUtils.requireNonNullOrThrow(this.toIngredient(addition), "warning.config.recipe.smithing_trim.missing_addition"), pattern);
        }
    }
}

