/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.CustomBlastingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomBrewingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCampfireRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmeltingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTrimRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmokingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomStoneCuttingRecipe;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeFactory;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class RecipeTypes {
    public static final Key SHAPED = Key.of("minecraft:shaped");
    public static final Key SHAPELESS = Key.of("minecraft:shapeless");
    public static final Key SMELTING = Key.of("minecraft:smelting");
    public static final Key BLASTING = Key.of("minecraft:blasting");
    public static final Key SMOKING = Key.of("minecraft:smoking");
    public static final Key CAMPFIRE_COOKING = Key.of("minecraft:campfire_cooking");
    public static final Key STONECUTTING = Key.of("minecraft:stonecutting");
    public static final Key SMITHING_TRANSFORM = Key.of("minecraft:smithing_transform");
    public static final Key SMITHING_TRIM = Key.of("minecraft:smithing_trim");
    public static final Key BREWING = Key.of("minecraft:brewing");

    public static <T> void register(Key key, RecipeFactory<T> factory) {
        ((WritableRegistry)BuiltInRegistries.RECIPE_FACTORY).register(ResourceKey.create(Registries.RECIPE_FACTORY.location(), key), factory);
    }

    public static <T> Recipe<T> fromMap(Key id, Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.recipe.missing_type");
        Key key = Key.withDefaultNamespace(type, "minecraft");
        RecipeFactory<?> factory = BuiltInRegistries.RECIPE_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.recipe.invalid_type", type);
        }
        return factory.create(id, map);
    }

    static {
        RecipeTypes.register(SHAPED, CustomShapedRecipe.FACTORY);
        RecipeTypes.register(SHAPELESS, CustomShapelessRecipe.FACTORY);
        RecipeTypes.register(SMELTING, CustomSmeltingRecipe.FACTORY);
        RecipeTypes.register(SMOKING, CustomSmokingRecipe.FACTORY);
        RecipeTypes.register(BLASTING, CustomBlastingRecipe.FACTORY);
        RecipeTypes.register(CAMPFIRE_COOKING, CustomCampfireRecipe.FACTORY);
        RecipeTypes.register(STONECUTTING, CustomStoneCuttingRecipe.FACTORY);
        RecipeTypes.register(SMITHING_TRANSFORM, CustomSmithingTransformRecipe.FACTORY);
        RecipeTypes.register(SMITHING_TRIM, CustomSmithingTrimRecipe.FACTORY);
        RecipeTypes.register(BREWING, CustomBrewingRecipe.FACTORY);
    }
}

