/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe.input;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.momirealms.craftengine.core.item.recipe.RecipeFinder;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;

public final class CraftingInput<T>
implements RecipeInput {
    private final int width;
    private final int height;
    private final List<UniqueIdItem<T>> items;
    private final int ingredientCount;
    private final RecipeFinder finder = new RecipeFinder();

    private CraftingInput(int width, int height, List<UniqueIdItem<T>> items) {
        this.height = height;
        this.width = width;
        this.items = items;
        int i = 0;
        for (UniqueIdItem<T> item : items) {
            if (item.isEmpty()) continue;
            ++i;
            this.finder.addInput(item);
        }
        this.ingredientCount = i;
    }

    public RecipeFinder finder() {
        return this.finder;
    }

    public static <T> CraftingInput<T> of(int width, int height, List<UniqueIdItem<T>> stacks) {
        if (width <= 0 || height <= 0) {
            return new CraftingInput<T>(0, 0, Collections.emptyList());
        }
        int minCol = width;
        int maxCol = -1;
        int minRow = height;
        int maxRow = -1;
        for (int index = 0; index < width * height; ++index) {
            UniqueIdItem<T> item = stacks.get(index);
            if (item.isEmpty()) continue;
            int row = index / width;
            int col = index % width;
            minCol = Math.min(minCol, col);
            maxCol = Math.max(maxCol, col);
            minRow = Math.min(minRow, row);
            maxRow = Math.max(maxRow, row);
        }
        if (maxCol < minCol) {
            return new CraftingInput<T>(0, 0, Collections.emptyList());
        }
        int newWidth = maxCol - minCol + 1;
        int newHeight = maxRow - minRow + 1;
        if (newWidth == width && newHeight == height) {
            return new CraftingInput<T>(width, height, stacks);
        }
        ArrayList<UniqueIdItem<T>> trimmed = new ArrayList<UniqueIdItem<T>>(newWidth * newHeight);
        for (int row = minRow; row <= maxRow; ++row) {
            for (int col = minCol; col <= maxCol; ++col) {
                int originalIndex = col + row * width;
                trimmed.add(stacks.get(originalIndex));
            }
        }
        return new CraftingInput<T>(newWidth, newHeight, trimmed);
    }

    public int ingredientCount() {
        return this.ingredientCount;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int size() {
        return this.items.size();
    }

    public UniqueIdItem<T> getItem(int x, int y) {
        return this.items.get(x + y * this.width);
    }

    public UniqueIdItem<T> getItem(int index) {
        return this.items.get(index);
    }
}

