/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.entry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.loot.LootConditions;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.entry.AbstractCompositeLootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainerFactory;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainers;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.util.Key;

public class AlternativesLootEntryContainer<T>
extends AbstractCompositeLootEntryContainer<T> {
    public static final Factory<?> FACTORY = new Factory();

    protected AlternativesLootEntryContainer(List<Condition<LootContext>> conditions, List<LootEntryContainer<T>> children) {
        super(conditions, children);
    }

    @Override
    protected LootEntryContainer<T> compose(List<? extends LootEntryContainer<T>> children) {
        return switch (children.size()) {
            case 0 -> LootEntryContainer.alwaysFalse();
            case 1 -> children.get(0);
            case 2 -> children.get(0).or(children.get(1));
            default -> (context, choiceConsumer) -> {
                for (LootEntryContainer child : children) {
                    if (!child.expand(context, choiceConsumer)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    @Override
    public Key type() {
        return LootEntryContainers.ALTERNATIVES;
    }

    public static class Factory<A>
    implements LootEntryContainerFactory<A> {
        @Override
        public LootEntryContainer<A> create(Map<String, Object> arguments) {
            List containers = Optional.ofNullable(arguments.get("children")).map(it -> new ArrayList(LootEntryContainers.fromMapList((List)it))).orElse(Collections.emptyList());
            List<Condition<LootContext>> conditions = Optional.ofNullable(arguments.get("conditions")).map(it -> LootConditions.fromMapList((List)it)).orElse(Collections.emptyList());
            return new AlternativesLootEntryContainer(conditions, containers);
        }
    }
}

