/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModelFactory;
import net.momirealms.craftengine.core.pack.model.ItemModelReader;
import net.momirealms.craftengine.core.pack.model.ItemModels;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.model.select.SelectProperties;
import net.momirealms.craftengine.core.pack.model.select.SelectProperty;
import net.momirealms.craftengine.core.pack.revision.Revision;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersion;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.libraries.cloud.type.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectItemModel
implements ItemModel {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final SelectProperty property;
    private final Map<Either<JsonElement, List<JsonElement>>, ItemModel> whenMap;
    private final ItemModel fallBack;

    public SelectItemModel(@NotNull SelectProperty property, @NotNull Map<Either<JsonElement, List<JsonElement>>, ItemModel> whenMap, @Nullable ItemModel fallBack) {
        this.property = property;
        this.whenMap = whenMap;
        this.fallBack = fallBack;
    }

    public SelectProperty property() {
        return this.property;
    }

    public Map<Either<JsonElement, List<JsonElement>>, ItemModel> whenMap() {
        return this.whenMap;
    }

    public ItemModel fallBack() {
        return this.fallBack;
    }

    @Override
    public JsonObject apply(MinecraftVersion version) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type().toString());
        this.property.accept(json);
        JsonArray array = new JsonArray();
        json.add("cases", (JsonElement)array);
        for (Map.Entry<Either<JsonElement, List<JsonElement>>, ItemModel> entry : this.whenMap.entrySet()) {
            JsonObject item = new JsonObject();
            ItemModel itemModel = entry.getValue();
            item.add("model", (JsonElement)itemModel.apply(version));
            Either<JsonElement, List<JsonElement>> either = entry.getKey();
            if (either.primary().isPresent()) {
                item.add("when", (JsonElement)either.primary().get());
            } else {
                List list = (List)either.fallback().get();
                JsonArray whens = new JsonArray();
                for (JsonElement e : list) {
                    whens.add(e);
                }
                item.add("when", (JsonElement)whens);
            }
            array.add((JsonElement)item);
        }
        if (this.fallBack != null) {
            json.add("fallback", (JsonElement)this.fallBack.apply(version));
        }
        return json;
    }

    @Override
    public Key type() {
        return ItemModels.SELECT;
    }

    @Override
    public List<Revision> revisions() {
        ArrayList<Revision> versions = new ArrayList<Revision>();
        if (this.fallBack != null) {
            versions.addAll(this.fallBack.revisions());
        }
        for (ItemModel itemModel : this.whenMap.values()) {
            versions.addAll(itemModel.revisions());
        }
        return versions;
    }

    @Override
    public List<ModelGeneration> modelsToGenerate() {
        ArrayList<ModelGeneration> models = new ArrayList<ModelGeneration>(4);
        if (this.fallBack != null) {
            models.addAll(this.fallBack.modelsToGenerate());
        }
        for (ItemModel itemModel : this.whenMap.values()) {
            models.addAll(itemModel.modelsToGenerate());
        }
        return models;
    }

    public static class Factory
    implements ItemModelFactory {
        @Override
        public ItemModel create(Map<String, Object> arguments) {
            SelectProperty property = SelectProperties.fromMap(arguments);
            Map<String, Object> fallback = MiscUtils.castToMap(arguments.get("fallback"), true);
            Object casesObj = arguments.get("cases");
            if (casesObj instanceof List) {
                List list = (List)casesObj;
                List cases = list;
                if (!cases.isEmpty()) {
                    HashMap<Either<JsonElement, List<JsonElement>>, ItemModel> whenMap = new HashMap<Either<JsonElement, List<JsonElement>>, ItemModel>();
                    for (Map c : cases) {
                        Either either;
                        Object when = c.get("when");
                        if (when == null) {
                            throw new LocalizedResourceConfigException("warning.config.item.model.select.case.missing_when", new String[0]);
                        }
                        if (when instanceof List) {
                            List whenList = (List)when;
                            ArrayList<JsonElement> whens = new ArrayList<JsonElement>(whenList.size());
                            for (Object o : whenList) {
                                whens.add(GsonHelper.get().toJsonTree(o));
                            }
                            either = Either.ofFallback(whens);
                        } else {
                            either = Either.ofPrimary((Object)GsonHelper.get().toJsonTree(when));
                        }
                        Object model = c.get("model");
                        if (model == null) {
                            throw new LocalizedResourceConfigException("warning.config.item.model.select.case.missing_model", new String[0]);
                        }
                        whenMap.put((Either<JsonElement, List<JsonElement>>)either, ItemModels.fromMap(MiscUtils.castToMap(model, false)));
                    }
                    return new SelectItemModel(property, whenMap, fallback == null ? null : ItemModels.fromMap(fallback));
                }
                throw new LocalizedResourceConfigException("warning.config.item.model.select.missing_cases", new String[0]);
            }
            throw new LocalizedResourceConfigException("warning.config.item.model.select.missing_cases", new String[0]);
        }
    }

    public static class Reader
    implements ItemModelReader {
        @Override
        public ItemModel read(JsonObject json) {
            JsonArray cases = json.getAsJsonArray("cases");
            if (cases == null) {
                throw new IllegalArgumentException("cases is expected to be a JsonArray");
            }
            HashMap<Either<JsonElement, List<JsonElement>>, ItemModel> whenMap = new HashMap<Either<JsonElement, List<JsonElement>>, ItemModel>(cases.size());
            for (JsonElement e : cases) {
                if (e instanceof JsonObject) {
                    Either either;
                    JsonObject caseObj = (JsonObject)e;
                    ItemModel model = ItemModels.fromJson(caseObj.getAsJsonObject("model"));
                    JsonElement whenObj = caseObj.get("when");
                    if (whenObj instanceof JsonArray) {
                        JsonArray array = (JsonArray)whenObj;
                        ArrayList<JsonElement> whens = new ArrayList<JsonElement>(array.size());
                        for (JsonElement o : array) {
                            whens.add(o);
                        }
                        either = Either.ofFallback(whens);
                    } else if (whenObj != null) {
                        either = Either.ofPrimary((Object)whenObj);
                    } else {
                        throw new IllegalArgumentException("'when' should not be null");
                    }
                    whenMap.put((Either<JsonElement, List<JsonElement>>)either, model);
                    continue;
                }
                throw new IllegalArgumentException("case is expected to be a JsonObject");
            }
            return new SelectItemModel(SelectProperties.fromJson(json), whenMap, json.has("fallback") ? ItemModels.fromJson(json.getAsJsonObject("fallback")) : null);
        }
    }
}

