/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.condition;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.condition.ConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.ConditionPropertyFactory;
import net.momirealms.craftengine.core.pack.model.condition.ConditionPropertyReader;
import net.momirealms.craftengine.core.util.Key;

public class SimpleConditionProperty
implements ConditionProperty {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final Key type;

    public SimpleConditionProperty(Key type) {
        this.type = type;
    }

    @Override
    public Key type() {
        return this.type;
    }

    @Override
    public void accept(JsonObject jsonObject) {
        jsonObject.addProperty("property", this.type().toString());
    }

    public static class Factory
    implements ConditionPropertyFactory {
        @Override
        public ConditionProperty create(Map<String, Object> arguments) {
            Key type = Key.of(arguments.get("property").toString());
            return new SimpleConditionProperty(type);
        }
    }

    public static class Reader
    implements ConditionPropertyReader {
        @Override
        public ConditionProperty read(JsonObject json) {
            return new SimpleConditionProperty(Key.of(json.get("property").getAsString()));
        }
    }
}

