/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.rangedisptach;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperties;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchPropertyFactory;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchPropertyReader;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class UseCycleRangeDispatchProperty
implements RangeDispatchProperty {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final float period;

    public UseCycleRangeDispatchProperty(float period) {
        this.period = period;
    }

    @Override
    public Key type() {
        return RangeDispatchProperties.USE_CYCLE;
    }

    @Override
    public void accept(JsonObject jsonObject) {
        jsonObject.addProperty("property", this.type().toString());
        jsonObject.addProperty("period", (Number)Float.valueOf(this.period));
    }

    public static class Factory
    implements RangeDispatchPropertyFactory {
        @Override
        public RangeDispatchProperty create(Map<String, Object> arguments) {
            float period = ResourceConfigUtils.getAsFloat(arguments.getOrDefault("period", 0), "period");
            return new UseCycleRangeDispatchProperty(period);
        }
    }

    public static class Reader
    implements RangeDispatchPropertyReader {
        @Override
        public RangeDispatchProperty read(JsonObject json) {
            float period = json.has("period") ? json.get("period").getAsFloat() : 1.0f;
            return new UseCycleRangeDispatchProperty(period);
        }
    }
}

