/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.tint;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.tint.Tint;
import net.momirealms.craftengine.core.pack.model.tint.TintFactory;
import net.momirealms.craftengine.core.pack.model.tint.TintReader;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.cloud.type.Either;
import org.jetbrains.annotations.Nullable;

public class SimpleDefaultTint
implements Tint {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final Either<Integer, List<Float>> defaultValue;
    private final Key type;

    public SimpleDefaultTint(Key type, @Nullable Either<Integer, List<Float>> defaultValue) {
        this.defaultValue = defaultValue;
        this.type = type;
    }

    @Override
    public Key type() {
        return this.type;
    }

    @Override
    public JsonObject get() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type().toString());
        this.applyAnyTint(json, this.defaultValue, "default");
        return json;
    }

    public static class Factory
    implements TintFactory {
        @Override
        public Tint create(Map<String, Object> arguments) {
            Object value = arguments.containsKey("default") ? arguments.getOrDefault("default", 0) : arguments.getOrDefault("value", 0);
            Key type = Key.of(arguments.get("type").toString());
            return new SimpleDefaultTint(type, this.parseTintValue(value));
        }
    }

    public static class Reader
    implements TintReader {
        @Override
        public Tint read(JsonObject json) {
            return new SimpleDefaultTint(Key.of(json.get("type").getAsString()), this.parseTintValue(json.get("default")));
        }
    }
}

