/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.tint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.momirealms.craftengine.core.pack.model.tint.Tint;
import net.momirealms.craftengine.libraries.cloud.type.Either;

public interface TintReader {
    public Tint read(JsonObject var1);

    default public Either<Integer, List<Float>> parseTintValue(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)element;
            return Either.ofPrimary((Object)jsonPrimitive.getAsInt());
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            ArrayList<Float> result = new ArrayList<Float>();
            for (JsonElement jsonElement : array) {
                result.add(Float.valueOf(jsonElement.getAsFloat()));
            }
            return Either.ofFallback(result);
        }
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            throw new IllegalArgumentException("Can't parse tint value: " + String.valueOf(object));
        }
        return null;
    }
}

