/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.momirealms.craftengine.core.plugin.Plugin;
import net.momirealms.craftengine.core.plugin.command.AbstractCommandFeature;
import net.momirealms.craftengine.core.plugin.command.CommandConfig;
import net.momirealms.craftengine.core.plugin.command.CommandFeature;
import net.momirealms.craftengine.core.plugin.command.ConfigurableCommandBuilder;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.sender.Sender;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.locale.CraftEngineCaptionFormatter;
import net.momirealms.craftengine.core.plugin.locale.CraftEngineCaptionProvider;
import net.momirealms.craftengine.core.util.ArrayUtils;
import net.momirealms.craftengine.core.util.TriConsumer;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.adventure.text.TranslatableComponent;
import net.momirealms.craftengine.libraries.boostedyaml.YamlDocument;
import net.momirealms.craftengine.libraries.boostedyaml.block.implementation.Section;
import net.momirealms.craftengine.libraries.boostedyaml.dvs.versioning.BasicVersioning;
import net.momirealms.craftengine.libraries.boostedyaml.dvs.versioning.Versioning;
import net.momirealms.craftengine.libraries.boostedyaml.settings.dumper.DumperSettings;
import net.momirealms.craftengine.libraries.boostedyaml.settings.general.GeneralSettings;
import net.momirealms.craftengine.libraries.boostedyaml.settings.loader.LoaderSettings;
import net.momirealms.craftengine.libraries.boostedyaml.settings.updater.UpdaterSettings;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.caption.Caption;
import net.momirealms.craftengine.libraries.cloud.caption.StandardCaptionKeys;
import net.momirealms.craftengine.libraries.cloud.component.CommandComponent;
import net.momirealms.craftengine.libraries.cloud.exception.ArgumentParseException;
import net.momirealms.craftengine.libraries.cloud.exception.CommandExecutionException;
import net.momirealms.craftengine.libraries.cloud.exception.InvalidCommandSenderException;
import net.momirealms.craftengine.libraries.cloud.exception.InvalidSyntaxException;
import net.momirealms.craftengine.libraries.cloud.exception.NoPermissionException;
import net.momirealms.craftengine.libraries.cloud.minecraft.extras.MinecraftExceptionHandler;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommandManager<C>
implements CraftEngineCommandManager<C> {
    protected final HashSet<CommandComponent<C>> registeredRootCommandComponents = new HashSet();
    protected final HashSet<CommandFeature<C>> registeredFeatures = new HashSet();
    protected final CommandManager<C> commandManager;
    protected final Plugin plugin;
    private final CraftEngineCaptionFormatter<C> captionFormatter;
    private final MinecraftExceptionHandler.Decorator<C> decorator = (formatter, ctx, msg) -> msg;
    private TriConsumer<C, String, Component> feedbackConsumer;

    public AbstractCommandManager(Plugin plugin, CommandManager<C> commandManager) {
        this.commandManager = commandManager;
        this.plugin = plugin;
        this.inject();
        this.feedbackConsumer = this.defaultFeedbackConsumer();
        this.captionFormatter = new CraftEngineCaptionFormatter(plugin.translationManager());
    }

    @Override
    public void setFeedbackConsumer(@NotNull TriConsumer<C, String, Component> feedbackConsumer) {
        this.feedbackConsumer = feedbackConsumer;
    }

    @Override
    public TriConsumer<C, String, Component> defaultFeedbackConsumer() {
        return (sender, node, component) -> this.wrapSender(sender).sendMessage((Component)component, true);
    }

    protected abstract Sender wrapSender(C var1);

    private void inject() {
        this.getCommandManager().captionRegistry().registerProvider(new CraftEngineCaptionProvider());
        this.injectExceptionHandler(InvalidSyntaxException.class, MinecraftExceptionHandler.createDefaultInvalidSyntaxHandler(), StandardCaptionKeys.EXCEPTION_INVALID_SYNTAX);
        this.injectExceptionHandler(InvalidCommandSenderException.class, MinecraftExceptionHandler.createDefaultInvalidSenderHandler(), StandardCaptionKeys.EXCEPTION_INVALID_SENDER);
        this.injectExceptionHandler(NoPermissionException.class, MinecraftExceptionHandler.createDefaultNoPermissionHandler(), StandardCaptionKeys.EXCEPTION_NO_PERMISSION);
        this.injectExceptionHandler(ArgumentParseException.class, MinecraftExceptionHandler.createDefaultArgumentParsingHandler(), StandardCaptionKeys.EXCEPTION_INVALID_ARGUMENT);
        this.injectExceptionHandler(CommandExecutionException.class, MinecraftExceptionHandler.createDefaultCommandExecutionHandler(), StandardCaptionKeys.EXCEPTION_UNEXPECTED);
    }

    private void injectExceptionHandler(Class<? extends Throwable> type, MinecraftExceptionHandler.MessageFactory<C, ?> factory, Caption key) {
        this.getCommandManager().exceptionController().registerHandler(type, ctx -> {
            @Nullable ComponentLike message = factory.message(this.captionFormatter, ctx);
            if (message != null) {
                this.handleCommandFeedback(ctx.context().sender(), key.key(), this.decorator.decorate(this.captionFormatter, ctx, message.asComponent()).asComponent());
            }
        });
    }

    @Override
    public CommandConfig<C> getCommandConfig(YamlDocument document, String featureID) {
        Section section = document.getSection(featureID);
        if (section == null) {
            return null;
        }
        return new CommandConfig.Builder().permission(section.getString("permission")).usages(section.getStringList("usage")).enable(section.getBoolean("enable", Boolean.valueOf(false))).build();
    }

    @Override
    public Collection<Command.Builder<C>> buildCommandBuilders(CommandConfig<C> config) {
        ArrayList<Command.Builder<C>> list = new ArrayList<Command.Builder<C>>();
        for (String usage : config.getUsages()) {
            if (!usage.startsWith("/")) continue;
            String command = usage.substring(1).trim();
            String[] split = command.split(" ");
            Command.Builder<C> builder = new ConfigurableCommandBuilder.BasicConfigurableCommandBuilder<C>(this.getCommandManager(), split[0]).nodes(ArrayUtils.subArray(split, 1)).permission(config.getPermission()).build();
            list.add(builder);
        }
        return list;
    }

    @Override
    public void registerFeature(CommandFeature<C> feature, CommandConfig<C> config) {
        if (!config.isEnable()) {
            throw new RuntimeException("Registering a disabled command feature is not allowed");
        }
        for (Command.Builder<C> builder : this.buildCommandBuilders(config)) {
            Command<C> command = feature.registerCommand(this.commandManager, builder);
            this.registeredRootCommandComponents.add(command.rootComponent());
        }
        feature.registerRelatedFunctions();
        this.registeredFeatures.add(feature);
        ((AbstractCommandFeature)feature).setCommandConfig(config);
    }

    @Override
    public void registerDefaultFeatures() {
        YamlDocument document = Config.instance().loadYamlConfig("commands.yml", GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("config-version")).build());
        try {
            document.save(new File(this.plugin.dataFolderFile(), "commands.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.features().values().forEach(feature -> {
            CommandConfig<C> config = this.getCommandConfig(document, feature.getFeatureID());
            if (config.isEnable()) {
                this.registerFeature((CommandFeature<C>)feature, config);
            }
        });
    }

    @Override
    public void unregisterFeatures() {
        this.registeredRootCommandComponents.forEach(component -> this.commandManager.commandRegistrationHandler().unregisterRootCommand(component));
        this.registeredRootCommandComponents.clear();
        this.registeredFeatures.forEach(CommandFeature::unregisterRelatedFunctions);
        this.registeredFeatures.clear();
    }

    @Override
    public CommandManager<C> getCommandManager() {
        return this.commandManager;
    }

    @Override
    public void handleCommandFeedback(C sender, TranslatableComponent.Builder key, Component ... args) {
        TranslatableComponent component = (TranslatableComponent)key.arguments((ComponentLike[])args).build();
        this.feedbackConsumer.accept(sender, component.key(), this.plugin.translationManager().render((Component)component));
    }

    @Override
    public void handleCommandFeedback(C sender, String node, Component component) {
        this.feedbackConsumer.accept(sender, node, component);
    }
}

