/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.entity.furniture.ColliderType;
import net.momirealms.craftengine.core.pack.AbstractPackManager;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionConditional;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.PluginProperties;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.plugin.logger.filter.DisconnectLogFilter;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersion;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.world.InjectionTarget;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.boostedyaml.YamlDocument;
import net.momirealms.craftengine.libraries.boostedyaml.block.implementation.Section;
import net.momirealms.craftengine.libraries.boostedyaml.dvs.versioning.BasicVersioning;
import net.momirealms.craftengine.libraries.boostedyaml.dvs.versioning.Versioning;
import net.momirealms.craftengine.libraries.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import net.momirealms.craftengine.libraries.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import net.momirealms.craftengine.libraries.boostedyaml.settings.Settings;
import net.momirealms.craftengine.libraries.boostedyaml.settings.dumper.DumperSettings;
import net.momirealms.craftengine.libraries.boostedyaml.settings.general.GeneralSettings;
import net.momirealms.craftengine.libraries.boostedyaml.settings.loader.LoaderSettings;
import net.momirealms.craftengine.libraries.boostedyaml.settings.updater.UpdaterSettings;
import net.momirealms.craftengine.libraries.boostedyaml.utils.format.NodeRole;

public class Config {
    private static Config instance;
    protected final CraftEngine plugin;
    private final Path configFilePath;
    private final String configVersion;
    private YamlDocument config;
    private long lastModified;
    private long size;
    protected boolean firstTime = true;
    protected boolean checkUpdate;
    protected boolean metrics;
    protected boolean filterConfigurationPhaseDisconnect;
    protected boolean debug$common;
    protected boolean debug$packet;
    protected boolean debug$item;
    protected boolean debug$furniture;
    protected boolean debug$resource_pack;
    protected boolean resource_pack$remove_tinted_leaves_particle;
    protected boolean resource_pack$generate_mod_assets;
    protected boolean resource_pack$override_uniform_font;
    protected List<ResolutionConditional> resource_pack$duplicated_files_handler;
    protected List<String> resource_pack$merge_external_folders;
    protected List<String> resource_pack$merge_external_zips;
    protected Set<String> resource_pack$exclude_file_extensions;
    protected boolean resource_pack$protection$crash_tools$method_1;
    protected boolean resource_pack$protection$crash_tools$method_2;
    protected boolean resource_pack$protection$crash_tools$method_3;
    protected boolean resource_pack$validate$enable;
    protected boolean resource_pack$exclude_core_shaders;
    protected boolean resource_pack$protection$obfuscation$enable;
    protected long resource_pack$protection$obfuscation$seed;
    protected boolean resource_pack$protection$obfuscation$fake_directory;
    protected boolean resource_pack$protection$obfuscation$escape_unicode;
    protected boolean resource_pack$protection$obfuscation$break_json;
    protected boolean resource_pack$protection$obfuscation$resource_location$enable;
    protected int resource_pack$protection$obfuscation$resource_location$random_namespace$length;
    protected int resource_pack$protection$obfuscation$resource_location$random_namespace$amount;
    protected String resource_pack$protection$obfuscation$resource_location$random_path$source;
    protected int resource_pack$protection$obfuscation$resource_location$random_path$depth;
    protected boolean resource_pack$protection$obfuscation$resource_location$random_path$anti_unzip;
    protected int resource_pack$protection$obfuscation$resource_location$random_atlas$images_per_canvas;
    protected boolean resource_pack$protection$obfuscation$resource_location$random_atlas$use_double;
    protected List<String> resource_pack$protection$obfuscation$resource_location$bypass_textures;
    protected List<String> resource_pack$protection$obfuscation$resource_location$bypass_models;
    protected List<String> resource_pack$protection$obfuscation$resource_location$bypass_sounds;
    protected List<String> resource_pack$protection$obfuscation$resource_location$bypass_equipments;
    protected MinecraftVersion resource_pack$supported_version$min;
    protected MinecraftVersion resource_pack$supported_version$max;
    protected String resource_pack$overlay_format;
    protected boolean resource_pack$delivery$kick_if_declined;
    protected boolean resource_pack$delivery$kick_if_failed_to_apply;
    protected boolean resource_pack$delivery$send_on_join;
    protected boolean resource_pack$delivery$resend_on_upload;
    protected boolean resource_pack$delivery$auto_upload;
    protected Path resource_pack$delivery$file_to_upload;
    protected Component resource_pack$send$prompt;
    protected int performance$max_note_block_chain_update_limit;
    protected int performance$max_tripwire_chain_update_limit;
    protected int performance$max_emojis_per_parse;
    protected boolean light_system$force_update_light;
    protected boolean light_system$enable;
    protected int chunk_system$compression_method;
    protected boolean chunk_system$restore_vanilla_blocks_on_chunk_unload;
    protected boolean chunk_system$restore_custom_blocks_on_chunk_load;
    protected boolean chunk_system$sync_custom_blocks_on_chunk_load;
    protected boolean chunk_system$cache_system;
    protected boolean chunk_system$injection$use_fast_method;
    protected boolean chunk_system$injection$target;
    protected boolean furniture$handle_invalid_furniture_on_chunk_load$enable;
    protected Map<String, String> furniture$handle_invalid_furniture_on_chunk_load$mapping;
    protected boolean furniture$hide_base_entity;
    protected ColliderType furniture$collision_entity_type;
    protected boolean block$sound_system$enable;
    protected boolean block$simplify_adventure_break_check;
    protected boolean block$simplify_adventure_place_check;
    protected boolean block$predict_breaking;
    protected int block$predict_breaking_interval;
    protected double block$extended_interaction_range;
    protected boolean recipe$enable;
    protected boolean recipe$disable_vanilla_recipes$all;
    protected Set<Key> recipe$disable_vanilla_recipes$list;
    protected List<String> recipe$ingredient_sources;
    protected boolean image$illegal_characters_filter$command;
    protected boolean image$illegal_characters_filter$chat;
    protected boolean image$illegal_characters_filter$anvil;
    protected boolean image$illegal_characters_filter$sign;
    protected boolean image$illegal_characters_filter$book;
    protected boolean image$intercept_packets$system_chat;
    protected boolean image$intercept_packets$tab_list;
    protected boolean image$intercept_packets$actionbar;
    protected boolean image$intercept_packets$title;
    protected boolean image$intercept_packets$bossbar;
    protected boolean image$intercept_packets$container;
    protected boolean image$intercept_packets$team;
    protected boolean image$intercept_packets$scoreboard;
    protected boolean image$intercept_packets$entity_name;
    protected boolean image$intercept_packets$text_display;
    protected boolean image$intercept_packets$armor_stand;
    protected boolean image$intercept_packets$player_info;
    protected boolean image$intercept_packets$set_score;
    protected boolean image$intercept_packets$item;
    protected boolean image$intercept_packets$advancement;
    protected boolean item$client_bound_model;
    protected boolean item$non_italic_tag;
    protected String equipment$sacrificed_vanilla_armor$type;
    protected Key equipment$sacrificed_vanilla_armor$asset_id;
    protected Key equipment$sacrificed_vanilla_armor$humanoid;
    protected Key equipment$sacrificed_vanilla_armor$humanoid_leggings;
    protected boolean emoji$chat;
    protected boolean emoji$book;
    protected boolean emoji$anvil;
    protected boolean emoji$sign;

    public Config(CraftEngine plugin) {
        this.plugin = plugin;
        this.configVersion = PluginProperties.getValue("config");
        this.configFilePath = this.plugin.dataFolderPath().resolve("config.yml");
        instance = this;
    }

    public void load() {
        block9: {
            if (!Files.exists(this.configFilePath, new LinkOption[0])) {
                this.plugin.saveResource("config.yml");
            }
            try {
                BasicFileAttributes attributes = Files.readAttributes(this.configFilePath, BasicFileAttributes.class, new LinkOption[0]);
                long lastModified = attributes.lastModifiedTime().toMillis();
                long size = attributes.size();
                if (lastModified == this.lastModified && size == this.size && this.config != null) break block9;
                byte[] configFileBytes = Files.readAllBytes(this.configFilePath);
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(configFileBytes);){
                    this.config = YamlDocument.create((InputStream)inputStream, (Settings[])new Settings[0]);
                    String configVersion = this.config.getString("config-version");
                    if (!configVersion.equals(this.configVersion)) {
                        this.updateConfigVersion(configFileBytes);
                    }
                }
                this.loadSettings();
                this.lastModified = lastModified;
                this.size = size;
            }
            catch (IOException e) {
                this.plugin.logger().severe("Failed to load config.yml", e);
            }
        }
    }

    private void updateConfigVersion(byte[] bytes) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            this.config = YamlDocument.create((InputStream)inputStream, (InputStream)this.plugin.resourceStream("config.yml"), (Settings[])new Settings[]{GeneralSettings.builder().setRouteSeparator('.').setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.builder().setEscapeUnprintable(false).setScalarFormatter((tag, value, role, def) -> {
                if (role == NodeRole.KEY) {
                    return ScalarStyle.PLAIN;
                }
                return tag == Tag.STR ? ScalarStyle.DOUBLE_QUOTED : ScalarStyle.PLAIN;
            }).build(), UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("config-version")).addIgnoredRoute(PluginProperties.getValue("config"), "resource-pack.delivery.hosting", '.').build()});
        }
        try {
            this.config.save(new File(this.plugin.dataFolderFile(), "config.yml"));
        }
        catch (IOException e) {
            this.plugin.logger().warn("Could not save config.yml", e);
        }
    }

    private void loadSettings() {
        Section section;
        YamlDocument config = this.settings();
        this.plugin.translationManager().forcedLocale(TranslationManager.parseLocale(config.getString("forced-locale", "")));
        this.metrics = config.getBoolean("metrics", Boolean.valueOf(false));
        this.checkUpdate = config.getBoolean("update-checker", Boolean.valueOf(false));
        this.filterConfigurationPhaseDisconnect = config.getBoolean("filter-configuration-phase-disconnect", Boolean.valueOf(false));
        DisconnectLogFilter.instance().setEnable(this.filterConfigurationPhaseDisconnect);
        this.debug$common = config.getBoolean("debug.common", Boolean.valueOf(false));
        this.debug$packet = config.getBoolean("debug.packet", Boolean.valueOf(false));
        this.debug$item = config.getBoolean("debug.item", Boolean.valueOf(false));
        this.debug$furniture = config.getBoolean("debug.furniture", Boolean.valueOf(false));
        this.debug$resource_pack = config.getBoolean("debug.resource-pack", Boolean.valueOf(false));
        this.resource_pack$override_uniform_font = config.getBoolean("resource-pack.override-uniform-font", Boolean.valueOf(false));
        this.resource_pack$generate_mod_assets = config.getBoolean("resource-pack.generate-mod-assets", Boolean.valueOf(false));
        this.resource_pack$remove_tinted_leaves_particle = config.getBoolean("resource-pack.remove-tinted-leaves-particle", Boolean.valueOf(true));
        this.resource_pack$supported_version$min = Config.getVersion(config.get("resource-pack.supported-version.min", (Object)"1.20").toString());
        this.resource_pack$supported_version$max = Config.getVersion(config.get("resource-pack.supported-version.max", (Object)"LATEST").toString());
        this.resource_pack$merge_external_folders = config.getStringList("resource-pack.merge-external-folders");
        this.resource_pack$merge_external_zips = config.getStringList("resource-pack.merge-external-zip-files");
        this.resource_pack$exclude_file_extensions = new HashSet<String>(config.getStringList("resource-pack.exclude-file-extensions"));
        this.resource_pack$delivery$send_on_join = config.getBoolean("resource-pack.delivery.send-on-join", Boolean.valueOf(true));
        this.resource_pack$delivery$resend_on_upload = config.getBoolean("resource-pack.delivery.resend-on-upload", Boolean.valueOf(true));
        this.resource_pack$delivery$kick_if_declined = config.getBoolean("resource-pack.delivery.kick-if-declined", Boolean.valueOf(true));
        this.resource_pack$delivery$kick_if_failed_to_apply = config.getBoolean("resource-pack.delivery.kick-if-failed-to-apply", Boolean.valueOf(true));
        this.resource_pack$delivery$auto_upload = config.getBoolean("resource-pack.delivery.auto-upload", Boolean.valueOf(true));
        this.resource_pack$delivery$file_to_upload = this.resolvePath(config.getString("resource-pack.delivery.file-to-upload", "./generated/resource_pack.zip"));
        this.resource_pack$send$prompt = AdventureHelper.miniMessage().deserialize((Object)config.getString("resource-pack.delivery.prompt", "<yellow>To fully experience our server, please accept our custom resource pack.</yellow>"));
        this.resource_pack$protection$crash_tools$method_1 = config.getBoolean("resource-pack.protection.crash-tools.method-1", Boolean.valueOf(false));
        this.resource_pack$protection$crash_tools$method_2 = config.getBoolean("resource-pack.protection.crash-tools.method-2", Boolean.valueOf(false));
        this.resource_pack$protection$crash_tools$method_3 = config.getBoolean("resource-pack.protection.crash-tools.method-3", Boolean.valueOf(false));
        this.resource_pack$protection$obfuscation$enable = config.getBoolean("resource-pack.protection.obfuscation.enable", Boolean.valueOf(false));
        this.resource_pack$protection$obfuscation$seed = config.getLong("resource-pack.protection.obfuscation.seed", Long.valueOf(0L));
        this.resource_pack$protection$obfuscation$fake_directory = config.getBoolean("resource-pack.protection.obfuscation.fake-directory", Boolean.valueOf(false));
        this.resource_pack$protection$obfuscation$escape_unicode = config.getBoolean("resource-pack.protection.obfuscation.escape-unicode", Boolean.valueOf(false));
        this.resource_pack$protection$obfuscation$break_json = config.getBoolean("resource-pack.protection.obfuscation.break-json", Boolean.valueOf(false));
        this.resource_pack$protection$obfuscation$resource_location$enable = config.getBoolean("resource-pack.protection.obfuscation.resource-location.enable", Boolean.valueOf(false));
        this.resource_pack$protection$obfuscation$resource_location$random_namespace$amount = config.getInt("resource-pack.protection.obfuscation.resource-location.random-namespace.amount", Integer.valueOf(32));
        this.resource_pack$protection$obfuscation$resource_location$random_namespace$length = config.getInt("resource-pack.protection.obfuscation.resource-location.random-namespace.length", Integer.valueOf(8));
        this.resource_pack$protection$obfuscation$resource_location$random_path$depth = config.getInt("resource-pack.protection.obfuscation.resource-location.random-path.depth", Integer.valueOf(16));
        this.resource_pack$protection$obfuscation$resource_location$random_path$source = config.getString("resource-pack.protection.obfuscation.resource-location.random-path.source", "obf");
        this.resource_pack$protection$obfuscation$resource_location$random_path$anti_unzip = config.getBoolean("resource-pack.protection.obfuscation.resource-location.random-path.anti-unzip", Boolean.valueOf(false));
        this.resource_pack$protection$obfuscation$resource_location$random_atlas$images_per_canvas = config.getInt("resource-pack.protection.obfuscation.resource-location.random-atlas.images-per-canvas", Integer.valueOf(16));
        this.resource_pack$protection$obfuscation$resource_location$random_atlas$use_double = config.getBoolean("resource-pack.protection.obfuscation.resource-location.random-atlas.use-double", Boolean.valueOf(true));
        this.resource_pack$protection$obfuscation$resource_location$bypass_textures = config.getStringList("resource-pack.protection.obfuscation.resource-location.bypass-textures");
        this.resource_pack$protection$obfuscation$resource_location$bypass_models = config.getStringList("resource-pack.protection.obfuscation.resource-location.bypass-models");
        this.resource_pack$protection$obfuscation$resource_location$bypass_sounds = config.getStringList("resource-pack.protection.obfuscation.resource-location.bypass-sounds");
        this.resource_pack$protection$obfuscation$resource_location$bypass_equipments = config.getStringList("resource-pack.protection.obfuscation.resource-location.bypass-equipments");
        this.resource_pack$validate$enable = config.getBoolean("resource-pack.validate.enable", Boolean.valueOf(true));
        this.resource_pack$exclude_core_shaders = config.getBoolean("resource-pack.exclude-core-shaders", Boolean.valueOf(false));
        this.resource_pack$overlay_format = config.getString("resource-pack.overlay-format", "overlay_{version}");
        if (!this.resource_pack$overlay_format.contains("{version}")) {
            TranslationManager.instance().log("warning.config.resource_pack.invalid_overlay_format", this.resource_pack$overlay_format);
        }
        try {
            this.resource_pack$duplicated_files_handler = config.getMapList("resource-pack.duplicated-files-handler").stream().map(it -> {
                Map<String, Object> args = MiscUtils.castToMap(it, false);
                return ResolutionConditional.FACTORY.create((Map)args);
            }).toList();
        }
        catch (LocalizedResourceConfigException e) {
            TranslationManager.instance().log(e.node(), e.arguments());
            this.resource_pack$duplicated_files_handler = List.of();
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to load resource-pack.duplicated-files-handler", e);
            this.resource_pack$duplicated_files_handler = List.of();
        }
        this.performance$max_note_block_chain_update_limit = config.getInt("performance.max-note-block-chain-update-limit", Integer.valueOf(64));
        this.performance$max_tripwire_chain_update_limit = config.getInt("performance.max-tripwire-chain-update-limit", Integer.valueOf(128));
        this.performance$max_emojis_per_parse = config.getInt("performance.max-emojis-per-parse", Integer.valueOf(32));
        this.light_system$force_update_light = config.getBoolean("light-system.force-update-light", Boolean.valueOf(false));
        this.light_system$enable = config.getBoolean("light-system.enable", Boolean.valueOf(true));
        this.chunk_system$compression_method = config.getInt("chunk-system.compression-method", Integer.valueOf(4));
        this.chunk_system$restore_vanilla_blocks_on_chunk_unload = config.getBoolean("chunk-system.restore-vanilla-blocks-on-chunk-unload", Boolean.valueOf(true));
        this.chunk_system$restore_custom_blocks_on_chunk_load = config.getBoolean("chunk-system.restore-custom-blocks-on-chunk-load", Boolean.valueOf(true));
        this.chunk_system$sync_custom_blocks_on_chunk_load = config.getBoolean("chunk-system.sync-custom-blocks-on-chunk-load", Boolean.valueOf(false));
        this.chunk_system$cache_system = config.getBoolean("chunk-system.cache-system", Boolean.valueOf(true));
        this.chunk_system$injection$use_fast_method = config.getBoolean("chunk-system.injection.use-fast-method", Boolean.valueOf(false));
        if (this.firstTime) {
            this.chunk_system$injection$target = config.getEnum("chunk-system.injection.target", InjectionTarget.class, (Enum)InjectionTarget.PALETTE) == InjectionTarget.PALETTE;
        }
        this.furniture$handle_invalid_furniture_on_chunk_load$enable = config.getBoolean("furniture.handle-invalid-furniture-on-chunk-load.enable", Boolean.valueOf(false));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String furniture : config.getStringList("furniture.handle-invalid-furniture-on-chunk-load.remove")) {
            builder.put((Object)furniture, (Object)"");
        }
        if (config.contains("furniture.handle-invalid-furniture-on-chunk-load.convert") && (section = config.getSection("furniture.handle-invalid-furniture-on-chunk-load.convert")) != null) {
            for (Map.Entry entry : section.getStringRouteMappedValues(false).entrySet()) {
                builder.put((Object)((String)entry.getKey()), (Object)entry.getValue().toString());
            }
        }
        this.furniture$handle_invalid_furniture_on_chunk_load$mapping = builder.build();
        this.furniture$hide_base_entity = config.getBoolean("furniture.hide-base-entity", Boolean.valueOf(true));
        this.furniture$collision_entity_type = ColliderType.valueOf(config.getString("furniture.collision-entity-type", "interaction").toUpperCase(Locale.ENGLISH));
        this.equipment$sacrificed_vanilla_armor$type = config.getString("equipment.sacrificed-vanilla-armor.type", "chainmail").toLowerCase(Locale.ENGLISH);
        if (!AbstractPackManager.ALLOWED_VANILLA_EQUIPMENT.contains(this.equipment$sacrificed_vanilla_armor$type)) {
            TranslationManager.instance().log("warning.config.equipment.invalid_sacrificed_armor", this.equipment$sacrificed_vanilla_armor$type);
            this.equipment$sacrificed_vanilla_armor$type = "chainmail";
        }
        this.equipment$sacrificed_vanilla_armor$asset_id = Key.of(config.getString("equipment.sacrificed-vanilla-armor.asset-id", "minecraft:chainmail"));
        this.equipment$sacrificed_vanilla_armor$humanoid = Key.of(config.getString("equipment.sacrificed-vanilla-armor.humanoid", "minecraft:trims/entity/humanoid/chainmail"));
        this.equipment$sacrificed_vanilla_armor$humanoid_leggings = Key.of(config.getString("equipment.sacrificed-vanilla-armor.humanoid-leggings", "minecraft:trims/entity/humanoid_leggings/chainmail"));
        this.item$client_bound_model = config.getBoolean("item.client-bound-model", Boolean.valueOf(false));
        this.item$non_italic_tag = config.getBoolean("item.non-italic-tag", Boolean.valueOf(false));
        this.block$sound_system$enable = config.getBoolean("block.sound-system.enable", Boolean.valueOf(true));
        this.block$simplify_adventure_break_check = config.getBoolean("block.simplify-adventure-break-check", Boolean.valueOf(false));
        this.block$simplify_adventure_place_check = config.getBoolean("block.simplify-adventure-place-check", Boolean.valueOf(false));
        this.block$predict_breaking = config.getBoolean("block.predict-breaking.enable", Boolean.valueOf(true));
        this.block$predict_breaking_interval = Math.max(config.getInt("block.predict-breaking.interval", Integer.valueOf(10)), 1);
        this.block$extended_interaction_range = Math.max(config.getDouble("block.predict-breaking.extended-interaction-range", Double.valueOf(0.5)), 0.0);
        this.recipe$enable = config.getBoolean("recipe.enable", Boolean.valueOf(true));
        this.recipe$disable_vanilla_recipes$all = config.getBoolean("recipe.disable-vanilla-recipes.all", Boolean.valueOf(false));
        this.recipe$disable_vanilla_recipes$list = config.getStringList("recipe.disable-vanilla-recipes.list").stream().map(Key::of).collect(Collectors.toSet());
        this.recipe$ingredient_sources = config.getStringList("recipe.ingredient-sources");
        this.image$illegal_characters_filter$anvil = config.getBoolean("image.illegal-characters-filter.anvil", Boolean.valueOf(true));
        this.image$illegal_characters_filter$book = config.getBoolean("image.illegal-characters-filter.book", Boolean.valueOf(true));
        this.image$illegal_characters_filter$chat = config.getBoolean("image.illegal-characters-filter.chat", Boolean.valueOf(true));
        this.image$illegal_characters_filter$command = config.getBoolean("image.illegal-characters-filter.command", Boolean.valueOf(true));
        this.image$illegal_characters_filter$sign = config.getBoolean("image.illegal-characters-filter.sign", Boolean.valueOf(true));
        this.image$intercept_packets$system_chat = config.getBoolean("image.intercept-packets.system-chat", Boolean.valueOf(true));
        this.image$intercept_packets$tab_list = config.getBoolean("image.intercept-packets.tab-list", Boolean.valueOf(true));
        this.image$intercept_packets$actionbar = config.getBoolean("image.intercept-packets.actionbar", Boolean.valueOf(true));
        this.image$intercept_packets$title = config.getBoolean("image.intercept-packets.title", Boolean.valueOf(true));
        this.image$intercept_packets$bossbar = config.getBoolean("image.intercept-packets.bossbar", Boolean.valueOf(true));
        this.image$intercept_packets$container = config.getBoolean("image.intercept-packets.container", Boolean.valueOf(true));
        this.image$intercept_packets$team = config.getBoolean("image.intercept-packets.team", Boolean.valueOf(true));
        this.image$intercept_packets$scoreboard = config.getBoolean("image.intercept-packets.scoreboard", Boolean.valueOf(true));
        this.image$intercept_packets$entity_name = config.getBoolean("image.intercept-packets.entity-name", Boolean.valueOf(false));
        this.image$intercept_packets$text_display = config.getBoolean("image.intercept-packets.text-display", Boolean.valueOf(true));
        this.image$intercept_packets$armor_stand = config.getBoolean("image.intercept-packets.armor-stand", Boolean.valueOf(true));
        this.image$intercept_packets$player_info = config.getBoolean("image.intercept-packets.player-info", Boolean.valueOf(true));
        this.image$intercept_packets$set_score = config.getBoolean("image.intercept-packets.set-score", Boolean.valueOf(true));
        this.image$intercept_packets$item = config.getBoolean("image.intercept-packets.item", Boolean.valueOf(true));
        this.image$intercept_packets$advancement = config.getBoolean("image.intercept-packets.advancement", Boolean.valueOf(true));
        this.emoji$chat = config.getBoolean("emoji.chat", Boolean.valueOf(true));
        this.emoji$anvil = config.getBoolean("emoji.anvil", Boolean.valueOf(true));
        this.emoji$book = config.getBoolean("emoji.book", Boolean.valueOf(true));
        this.emoji$sign = config.getBoolean("emoji.sign", Boolean.valueOf(true));
        this.firstTime = false;
    }

    private static MinecraftVersion getVersion(String version) {
        if (version.equalsIgnoreCase("LATEST")) {
            return new MinecraftVersion(PluginProperties.getValue("latest-version"));
        }
        return MinecraftVersion.parse(version);
    }

    public static String configVersion() {
        return Config.instance.configVersion;
    }

    public static boolean debugCommon() {
        return Config.instance.debug$common;
    }

    public static boolean debugPacket() {
        return Config.instance.debug$packet;
    }

    public static boolean debugItem() {
        return Config.instance.debug$item;
    }

    public static boolean debugFurniture() {
        return Config.instance.debug$furniture;
    }

    public static boolean debugResourcePack() {
        return Config.instance.debug$resource_pack;
    }

    public static boolean checkUpdate() {
        return Config.instance.checkUpdate;
    }

    public static boolean metrics() {
        return Config.instance.metrics;
    }

    public static boolean filterConfigurationPhaseDisconnect() {
        return Config.instance.filterConfigurationPhaseDisconnect;
    }

    public static boolean resourcePack$overrideUniform() {
        return Config.instance.resource_pack$override_uniform_font;
    }

    public static int maxNoteBlockChainUpdate() {
        return Config.instance.performance$max_note_block_chain_update_limit;
    }

    public static int maxEmojisPerParse() {
        return Config.instance.performance$max_emojis_per_parse;
    }

    public static boolean handleInvalidFurniture() {
        return Config.instance.furniture$handle_invalid_furniture_on_chunk_load$enable;
    }

    public static Map<String, String> furnitureMappings() {
        return Config.instance.furniture$handle_invalid_furniture_on_chunk_load$mapping;
    }

    public static boolean enableLightSystem() {
        return Config.instance.light_system$enable;
    }

    public static MinecraftVersion packMinVersion() {
        return Config.instance.resource_pack$supported_version$min;
    }

    public static MinecraftVersion packMaxVersion() {
        return Config.instance.resource_pack$supported_version$max;
    }

    public static boolean enableSoundSystem() {
        return Config.instance.block$sound_system$enable;
    }

    public static boolean simplifyAdventureBreakCheck() {
        return Config.instance.block$simplify_adventure_break_check;
    }

    public static boolean simplifyAdventurePlaceCheck() {
        return Config.instance.block$simplify_adventure_place_check;
    }

    public static boolean enableRecipeSystem() {
        return Config.instance.recipe$enable;
    }

    public static boolean disableAllVanillaRecipes() {
        return Config.instance.recipe$disable_vanilla_recipes$all;
    }

    public static Set<Key> disabledVanillaRecipes() {
        return Config.instance.recipe$disable_vanilla_recipes$list;
    }

    public static boolean restoreVanillaBlocks() {
        return Config.instance.chunk_system$restore_vanilla_blocks_on_chunk_unload && Config.instance.chunk_system$restore_custom_blocks_on_chunk_load;
    }

    public static boolean restoreCustomBlocks() {
        return Config.instance.chunk_system$restore_custom_blocks_on_chunk_load;
    }

    public static boolean syncCustomBlocks() {
        return Config.instance.chunk_system$sync_custom_blocks_on_chunk_load;
    }

    public static List<String> foldersToMerge() {
        return Config.instance.resource_pack$merge_external_folders;
    }

    public static List<String> zipsToMerge() {
        return Config.instance.resource_pack$merge_external_zips;
    }

    public static Set<String> excludeFileExtensions() {
        return Config.instance.resource_pack$exclude_file_extensions;
    }

    public static boolean kickOnDeclined() {
        return Config.instance.resource_pack$delivery$kick_if_declined;
    }

    public static boolean kickOnFailedApply() {
        return Config.instance.resource_pack$delivery$kick_if_failed_to_apply;
    }

    public static Component resourcePackPrompt() {
        return Config.instance.resource_pack$send$prompt;
    }

    public static boolean sendPackOnJoin() {
        return Config.instance.resource_pack$delivery$send_on_join;
    }

    public static boolean sendPackOnUpload() {
        return Config.instance.resource_pack$delivery$resend_on_upload;
    }

    public static boolean autoUpload() {
        return Config.instance.resource_pack$delivery$auto_upload;
    }

    public static Path fileToUpload() {
        return Config.instance.resource_pack$delivery$file_to_upload;
    }

    public static List<ResolutionConditional> resolutions() {
        return Config.instance.resource_pack$duplicated_files_handler;
    }

    public static boolean crashTool1() {
        return Config.instance.resource_pack$protection$crash_tools$method_1;
    }

    public static boolean crashTool2() {
        return Config.instance.resource_pack$protection$crash_tools$method_2;
    }

    public static boolean crashTool3() {
        return Config.instance.resource_pack$protection$crash_tools$method_3;
    }

    public static boolean crashTool4() {
        return false;
    }

    public static boolean enableObfuscation() {
        return Config.instance.resource_pack$protection$obfuscation$enable;
    }

    public static long obfuscationSeed() {
        return Config.instance.resource_pack$protection$obfuscation$seed;
    }

    public static boolean createFakeDirectory() {
        return Config.instance.resource_pack$protection$obfuscation$fake_directory;
    }

    public static boolean escapeUnicode() {
        return Config.instance.resource_pack$protection$obfuscation$escape_unicode;
    }

    public static boolean breakJson() {
        return Config.instance.resource_pack$protection$obfuscation$break_json;
    }

    public static boolean enableRandomResourceLocation() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$enable;
    }

    public static int namespaceLength() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$random_namespace$length;
    }

    public static int namespaceAmount() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$random_namespace$amount;
    }

    public static String atlasSource() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$random_path$source;
    }

    public static int pathDepth() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$random_path$depth;
    }

    public static boolean antiUnzip() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$random_path$anti_unzip;
    }

    public static int imagesPerCanvas() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$random_atlas$images_per_canvas;
    }

    public static boolean useDouble() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$random_atlas$use_double;
    }

    public static List<String> bypassTextures() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$bypass_textures;
    }

    public static List<String> bypassModels() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$bypass_models;
    }

    public static List<String> bypassSounds() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$bypass_sounds;
    }

    public static List<String> bypassEquipments() {
        return Config.instance.resource_pack$protection$obfuscation$resource_location$bypass_equipments;
    }

    public static boolean generateModAssets() {
        return Config.instance.resource_pack$generate_mod_assets;
    }

    public static boolean removeTintedLeavesParticle() {
        return Config.instance.resource_pack$remove_tinted_leaves_particle;
    }

    public static boolean filterChat() {
        return Config.instance.image$illegal_characters_filter$chat;
    }

    public static boolean filterAnvil() {
        return Config.instance.image$illegal_characters_filter$anvil;
    }

    public static boolean filterCommand() {
        return Config.instance.image$illegal_characters_filter$command;
    }

    public static boolean filterBook() {
        return Config.instance.image$illegal_characters_filter$book;
    }

    public static boolean filterSign() {
        return Config.instance.image$illegal_characters_filter$sign;
    }

    public static boolean hideBaseEntity() {
        return Config.instance.furniture$hide_base_entity;
    }

    public static int compressionMethod() {
        int id = Config.instance.chunk_system$compression_method;
        if (id <= 0 || id > 5) {
            id = 4;
        }
        return id;
    }

    public static boolean interceptSystemChat() {
        return Config.instance.image$intercept_packets$system_chat;
    }

    public static boolean interceptTabList() {
        return Config.instance.image$intercept_packets$tab_list;
    }

    public static boolean interceptActionBar() {
        return Config.instance.image$intercept_packets$actionbar;
    }

    public static boolean interceptTitle() {
        return Config.instance.image$intercept_packets$title;
    }

    public static boolean interceptBossBar() {
        return Config.instance.image$intercept_packets$bossbar;
    }

    public static boolean interceptContainer() {
        return Config.instance.image$intercept_packets$container;
    }

    public static boolean interceptTeam() {
        return Config.instance.image$intercept_packets$team;
    }

    public static boolean interceptEntityName() {
        return Config.instance.image$intercept_packets$entity_name;
    }

    public static boolean interceptScoreboard() {
        return Config.instance.image$intercept_packets$scoreboard;
    }

    public static boolean interceptTextDisplay() {
        return Config.instance.image$intercept_packets$text_display;
    }

    public static boolean interceptArmorStand() {
        return Config.instance.image$intercept_packets$armor_stand;
    }

    public static boolean interceptPlayerInfo() {
        return Config.instance.image$intercept_packets$player_info;
    }

    public static boolean interceptSetScore() {
        return Config.instance.image$intercept_packets$set_score;
    }

    public static boolean interceptItem() {
        return Config.instance.image$intercept_packets$item;
    }

    public static boolean interceptAdvancement() {
        return Config.instance.image$intercept_packets$advancement;
    }

    public static boolean predictBreaking() {
        return Config.instance.block$predict_breaking;
    }

    public static int predictBreakingInterval() {
        return Config.instance.block$predict_breaking_interval;
    }

    public static double extendedInteractionRange() {
        return Config.instance.block$extended_interaction_range;
    }

    public static boolean allowEmojiSign() {
        return Config.instance.emoji$sign;
    }

    public static boolean allowEmojiChat() {
        return Config.instance.emoji$chat;
    }

    public static boolean allowEmojiAnvil() {
        return Config.instance.emoji$anvil;
    }

    public static boolean allowEmojiBook() {
        return Config.instance.emoji$book;
    }

    public static ColliderType colliderType() {
        return Config.instance.furniture$collision_entity_type;
    }

    public static boolean enableChunkCache() {
        return Config.instance.chunk_system$cache_system;
    }

    public static boolean addNonItalicTag() {
        return Config.instance.item$non_italic_tag;
    }

    public static boolean fastInjection() {
        return Config.instance.chunk_system$injection$use_fast_method;
    }

    public static boolean injectionTarget() {
        return Config.instance.chunk_system$injection$target;
    }

    public static boolean validateResourcePack() {
        return Config.instance.resource_pack$validate$enable;
    }

    public static boolean excludeShaders() {
        return Config.instance.resource_pack$exclude_core_shaders;
    }

    public static String createOverlayFolderName(String version) {
        return Config.instance.resource_pack$overlay_format.replace("{version}", version);
    }

    public static Key sacrificedAssetId() {
        return Config.instance.equipment$sacrificed_vanilla_armor$asset_id;
    }

    public static Key sacrificedHumanoid() {
        return Config.instance.equipment$sacrificed_vanilla_armor$humanoid;
    }

    public static Key sacrificedHumanoidLeggings() {
        return Config.instance.equipment$sacrificed_vanilla_armor$humanoid_leggings;
    }

    public static String sacrificedVanillaArmorType() {
        return Config.instance.equipment$sacrificed_vanilla_armor$type;
    }

    public static boolean globalClientboundModel() {
        return Config.instance.item$client_bound_model;
    }

    public static List<String> recipeIngredientSources() {
        return Config.instance.recipe$ingredient_sources;
    }

    public YamlDocument loadOrCreateYamlData(String fileName) {
        Path path = this.plugin.dataFolderPath().resolve(fileName);
        if (!Files.exists(path, new LinkOption[0])) {
            this.plugin.saveResource(fileName);
        }
        return this.loadYamlData(path);
    }

    public YamlDocument loadYamlConfig(String filePath, GeneralSettings generalSettings, LoaderSettings loaderSettings, DumperSettings dumperSettings, UpdaterSettings updaterSettings) {
        YamlDocument yamlDocument;
        FileInputStream inputStream = new FileInputStream(this.resolveConfig(filePath).toFile());
        try {
            yamlDocument = YamlDocument.create((InputStream)inputStream, (InputStream)this.plugin.resourceStream(filePath), (Settings[])new Settings[]{generalSettings, loaderSettings, dumperSettings, updaterSettings});
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.logger().severe("Failed to load config " + filePath, e);
                return null;
            }
        }
        ((InputStream)inputStream).close();
        return yamlDocument;
    }

    public YamlDocument loadYamlData(Path file) {
        YamlDocument yamlDocument;
        block8: {
            InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                yamlDocument = YamlDocument.create((InputStream)inputStream, (Settings[])new Settings[0]);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.plugin.logger().severe("Failed to load config " + String.valueOf(file), e);
                    return null;
                }
            }
            inputStream.close();
        }
        return yamlDocument;
    }

    public Path resolveConfig(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        filePath = filePath.replace('\\', '/');
        Path configFile = this.plugin.dataFolderPath().resolve(filePath);
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (InputStream is = this.plugin.resourceStream(filePath);){
                if (is == null) {
                    throw new IllegalArgumentException("The embedded resource '" + filePath + "' cannot be found");
                }
                Files.copy(is, configFile, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configFile;
    }

    private Path resolvePath(String path) {
        return path.startsWith(".") ? CraftEngine.instance().dataFolderPath().resolve(path) : Path.of(path, new String[0]);
    }

    public YamlDocument settings() {
        if (this.config == null) {
            throw new IllegalStateException("Main config not loaded");
        }
        return this.config;
    }

    public static Config instance() {
        return instance;
    }
}

