/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.LongTag;
import net.momirealms.craftengine.libraries.nbt.NBT;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class CooldownData {
    public static final Key COOLDOWN_KEY = Key.of("craftengine:cooldown");
    private final Map<String, Long> cooldownMap = Collections.synchronizedMap(new HashMap());

    public boolean isOnCooldown(String key) {
        long currentTime = System.currentTimeMillis();
        if (this.cooldownMap.containsKey(key)) {
            long expirationTime = this.cooldownMap.get(key);
            return currentTime < expirationTime;
        }
        return false;
    }

    public void setCooldown(String key, long duration) {
        this.cooldownMap.put(key, System.currentTimeMillis() + duration);
    }

    public void addCooldown(String key, long duration) {
        if (this.cooldownMap.containsKey(key)) {
            this.cooldownMap.put(key, this.cooldownMap.get(key) + duration);
        } else {
            this.setCooldown(key, duration);
        }
    }

    public void removeCooldown(String key) {
        this.cooldownMap.remove(key);
    }

    public void clearCooldowns() {
        this.cooldownMap.clear();
    }

    public static byte[] toBytes(CooldownData data) throws IOException {
        CompoundTag tag = new CompoundTag();
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : data.cooldownMap.entrySet()) {
            if (currentTime >= entry.getValue()) continue;
            tag.putLong(entry.getKey(), entry.getValue());
        }
        return NBT.toBytes(tag);
    }

    public static CooldownData fromBytes(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return new CooldownData();
        }
        CooldownData cd = new CooldownData();
        long currentTime = System.currentTimeMillis();
        CompoundTag tag = NBT.fromBytes(data);
        if (tag != null) {
            for (Map.Entry<String, Tag> entry : tag.tags.entrySet()) {
                LongTag longTag;
                long expire;
                Tag tag2 = entry.getValue();
                if (!(tag2 instanceof LongTag) || currentTime >= (expire = (longTag = (LongTag)tag2).getAsLong())) continue;
                cd.cooldownMap.put(entry.getKey(), expire);
            }
        }
        return cd;
    }

    public String toString() {
        return "CooldownData{cooldownMap=" + String.valueOf(this.cooldownMap) + "}";
    }
}

