/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import java.util.Optional;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.RelationalContext;
import net.momirealms.craftengine.core.plugin.text.minimessage.ExpressionTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.GlobalVariableTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.I18NTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.ImageTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.NamedArgumentTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.PlaceholderTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.RelationalPlaceholderTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.ShiftTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.ViewerNamedArgumentTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.ViewerPlaceholderTag;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;

public class ViewerContext
implements RelationalContext {
    private final Context owner;
    private final PlayerOptionalContext viewer;
    private TagResolver[] tagResolvers;

    public ViewerContext(Context owner, PlayerOptionalContext viewer) {
        this.owner = owner;
        this.viewer = viewer;
    }

    public static ViewerContext of(Context owner, PlayerOptionalContext viewer) {
        return new ViewerContext(owner, viewer);
    }

    @Override
    public <T> Optional<T> getViewerOptionalParameter(ContextKey<T> parameter) {
        return this.viewer.getOptionalParameter(parameter);
    }

    @Override
    public ContextHolder viewerContexts() {
        return this.viewer.contexts();
    }

    @Override
    public <T> T getViewerParameterOrThrow(ContextKey<T> parameter) {
        return this.viewer.getParameterOrThrow(parameter);
    }

    @Override
    public ContextHolder contexts() {
        return this.owner.contexts();
    }

    @Override
    public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter) {
        return this.owner.getOptionalParameter(parameter);
    }

    @Override
    public <T> T getParameterOrThrow(ContextKey<T> parameter) {
        return this.owner.getParameterOrThrow(parameter);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public TagResolver[] tagResolvers() {
        if (this.tagResolvers != null) return this.tagResolvers;
        Context context = this.owner;
        if (context instanceof PlayerOptionalContext) {
            PlayerOptionalContext context2 = (PlayerOptionalContext)context;
            if (context2.player != null && this.viewer.player != null) {
                this.tagResolvers = new TagResolver[]{new RelationalPlaceholderTag(context2.player, this.viewer.player, this), ShiftTag.INSTANCE, ImageTag.INSTANCE, new PlaceholderTag(this.owner), new ViewerPlaceholderTag(this.viewer), new NamedArgumentTag(this.owner), new ViewerNamedArgumentTag(this.viewer), new I18NTag(this), new ExpressionTag(this), new GlobalVariableTag(this)};
                return this.tagResolvers;
            }
        }
        this.tagResolvers = new TagResolver[]{ShiftTag.INSTANCE, ImageTag.INSTANCE, new PlaceholderTag(this.owner), new ViewerPlaceholderTag(this.viewer), new NamedArgumentTag(this.owner), new ViewerNamedArgumentTag(this.viewer), new I18NTag(this), new ExpressionTag(this), new GlobalVariableTag(this)};
        return this.tagResolvers;
    }
}

