/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.context.ChainParameterProvider;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.world.BlockInWorld;

public class BlockParameterProvider
implements ChainParameterProvider<BlockInWorld> {
    private static final Map<ContextKey<?>, Function<BlockInWorld, Object>> CONTEXT_FUNCTIONS = new HashMap();

    @Override
    public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter, BlockInWorld block) {
        return Optional.ofNullable(CONTEXT_FUNCTIONS.get(parameter)).map(f -> f.apply(block));
    }

    static {
        CONTEXT_FUNCTIONS.put(DirectContextParameters.X, BlockInWorld::x);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.Y, BlockInWorld::y);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.Z, BlockInWorld::z);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.BLOCK_X, BlockInWorld::x);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.BLOCK_Y, BlockInWorld::y);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.BLOCK_Z, BlockInWorld::z);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.CUSTOM_BLOCK, BlockInWorld::customBlock);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.CUSTOM_BLOCK_STATE, BlockInWorld::customBlockState);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.WORLD, BlockInWorld::world);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.POSITION, BlockInWorld::position);
    }
}

