/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.selector;

import java.util.Map;
import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.selector.AllPlayerSelector;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelector;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelectorFactory;
import net.momirealms.craftengine.core.plugin.context.selector.SelfPlayerSelector;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;
import org.jetbrains.annotations.Nullable;

public class PlayerSelectors {
    public static final Key ALL = Key.of("craftengine:all");
    public static final Key SELF = Key.of("craftengine:self");

    public static void register(Key key, PlayerSelectorFactory<?> factory) {
        ((WritableRegistry)BuiltInRegistries.PLAYER_SELECTOR_FACTORY).register(ResourceKey.create(Registries.PLAYER_SELECTOR_FACTORY.location(), key), factory);
    }

    @Nullable
    public static <CTX extends Context> PlayerSelector<CTX> fromObject(Object object, Function<Map<String, Object>, Condition<CTX>> conditionFactory) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Map<String, Object> selectorMap = MiscUtils.castToMap(map, false);
            return PlayerSelectors.fromMap(selectorMap, conditionFactory);
        }
        if (object instanceof String) {
            String target = (String)object;
            if (target.equals("all") || target.equals("@a")) {
                return new AllPlayerSelector();
            }
            if (target.equals("self") || target.equals("@s")) {
                return new SelfPlayerSelector();
            }
        }
        throw new LocalizedResourceConfigException("warning.config.selector.invalid_target", object.toString());
    }

    public static <CTX extends Context> PlayerSelector<CTX> fromMap(Map<String, Object> map, Function<Map<String, Object>, Condition<CTX>> conditionFactory) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.selector.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        PlayerSelectorFactory<?> factory = BuiltInRegistries.PLAYER_SELECTOR_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.selector.invalid_type", type);
        }
        return factory.create(map, conditionFactory);
    }

    static {
        PlayerSelectors.register(ALL, new AllPlayerSelector.FactoryImpl());
        PlayerSelectors.register(SELF, new SelfPlayerSelector.FactoryImpl());
    }
}

