/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.locale;

import java.util.Arrays;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalizedException
extends RuntimeException {
    private final String node;
    private String[] arguments;

    public LocalizedException(@NotNull String node, @Nullable Exception cause, String ... arguments) {
        super(node, cause);
        this.node = node;
        this.arguments = arguments != null ? Arrays.copyOf(arguments, arguments.length) : new String[]{};
    }

    public LocalizedException(@NotNull String node, String ... arguments) {
        this(node, (Exception)null, arguments);
    }

    public LocalizedException(@NotNull String node, @Nullable String[] prefixArgs, String ... suffixArgs) {
        this(node, (Exception)null, ArrayUtils.merge(prefixArgs != null ? prefixArgs : new String[]{}, suffixArgs != null ? suffixArgs : new String[]{}));
    }

    public String[] arguments() {
        return Arrays.copyOf(this.arguments, this.arguments.length);
    }

    public void setArgument(int index, @NotNull String argument) {
        if (index < 0 || index >= this.arguments.length) {
            throw new IndexOutOfBoundsException("Invalid argument index: " + index);
        }
        this.arguments[index] = argument;
    }

    public void appendHeadArgument(@NotNull String argument) {
        this.arguments = ArrayUtils.appendElementToArrayHead(this.arguments, argument);
    }

    public void appendTailArgument(@NotNull String argument) {
        this.arguments = ArrayUtils.appendElementToArrayTail(this.arguments, argument);
    }

    @NotNull
    public String node() {
        return this.node;
    }

    @Override
    public String getMessage() {
        return this.generateLocalizedMessage();
    }

    private String generateLocalizedMessage() {
        try {
            String rawMessage = TranslationManager.instance().miniMessageTranslation(this.node);
            String cleanMessage = AdventureHelper.miniMessage().stripTags(rawMessage);
            for (int i = 0; i < this.arguments.length; ++i) {
                cleanMessage = cleanMessage.replace("<arg:" + i + ">", this.arguments[i] != null ? this.arguments[i] : "null");
            }
            return cleanMessage;
        }
        catch (Exception e) {
            return String.format("Failed to translate. Node: %s, Arguments: %s. Cause: %s", this.node, Arrays.toString(this.arguments), e.getMessage());
        }
    }
}

