/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.logger.filter;

import net.momirealms.craftengine.core.plugin.logger.filter.Log4JFilter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

public class LogFilter
extends AbstractFilter
implements Log4JFilter {
    private static Filter.Result validateMessage(Message message) {
        if (message == null) {
            return Filter.Result.NEUTRAL;
        }
        return LogFilter.validateMessage(message.getFormattedMessage());
    }

    private static Filter.Result validateMessage(String message) {
        return message.startsWith("\"CraftEngine v") ? Filter.Result.DENY : Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(LogEvent event) {
        Message candidate = null;
        if (event != null) {
            candidate = event.getMessage();
        }
        return LogFilter.validateMessage(candidate);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return LogFilter.validateMessage(msg);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return LogFilter.validateMessage(msg);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        if (msg != null && level == Level.WARN) {
            return LogFilter.validateMessage(msg.toString());
        }
        return Filter.Result.NEUTRAL;
    }
}

