/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.QuaternionUtils;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MiscUtils {
    private MiscUtils() {
    }

    public static Map<String, Object> castToMap(Object obj, boolean allowNull) {
        if (allowNull && obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map;
        }
        throw new IllegalArgumentException("Expected Map, got: " + (obj == null ? null : obj.getClass().getSimpleName()));
    }

    public static List<Map<String, Object>> getAsMapList(Object obj) {
        if (obj == null) {
            return List.of();
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return list;
        }
        if (obj instanceof Map) {
            return List.of((Map)obj);
        }
        throw new IllegalArgumentException("Expected MapList/Map, got: " + obj.getClass().getSimpleName());
    }

    public static List<String> getAsStringList(Object o) {
        ArrayList<String> list = new ArrayList<String>();
        if (o instanceof List) {
            for (Object object : (List)o) {
                list.add(object.toString());
            }
        } else if (o instanceof String) {
            list.add((String)o);
        } else if (o != null) {
            list.add(o.toString());
        }
        return list;
    }

    public static <T> List<T> getAsList(Object o, Class<T> clazz) {
        if (o instanceof List) {
            List list = (List)o;
            if (list.isEmpty()) {
                return List.of();
            }
            if (clazz.isInstance(list.getFirst())) {
                return list;
            }
        }
        if (clazz.isInstance(o)) {
            return List.of(o);
        }
        return List.of();
    }

    public static Vector3f getAsVector3f(Object o, String option) {
        List list;
        if (o == null) {
            return new Vector3f();
        }
        if (o instanceof List && (list = (List)o).size() == 3) {
            return new Vector3f(Float.parseFloat(list.get(0).toString()), Float.parseFloat(list.get(1).toString()), Float.parseFloat(list.get(2).toString()));
        }
        String stringFormat = o.toString();
        String[] split = stringFormat.split(",");
        if (split.length == 3) {
            return new Vector3f(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]));
        }
        if (split.length == 1) {
            return new Vector3f(Float.parseFloat(split[0]));
        }
        throw new LocalizedResourceConfigException("warning.config.type.vector3f", stringFormat, option);
    }

    public static Quaternionf getAsQuaternionf(Object o, String option) {
        List list;
        if (o == null) {
            return new Quaternionf();
        }
        if (o instanceof List && (list = (List)o).size() == 4) {
            return new Quaternionf(Float.parseFloat(list.get(0).toString()), Float.parseFloat(list.get(1).toString()), Float.parseFloat(list.get(2).toString()), Float.parseFloat(list.get(3).toString()));
        }
        String stringFormat = o.toString();
        String[] split = stringFormat.split(",");
        if (split.length == 4) {
            return new Quaternionf(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
        }
        if (split.length == 3) {
            return QuaternionUtils.toQuaternionf((float)Math.toRadians(Float.parseFloat(split[2])), (float)Math.toRadians(Float.parseFloat(split[1])), (float)Math.toRadians(Float.parseFloat(split[0])));
        }
        if (split.length == 1) {
            return QuaternionUtils.toQuaternionf(0.0f, (float)(-Math.toRadians(Float.parseFloat(split[0]))), 0.0f);
        }
        throw new LocalizedResourceConfigException("warning.config.type.quaternionf", stringFormat, option);
    }

    public static void deepMergeMaps(Map<String, Object> baseMap, Map<String, Object> mapToMerge) {
        for (Map.Entry<String, Object> entry : mapToMerge.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key.length() > 2 && key.charAt(0) == '$' && key.charAt(1) == '$') {
                value = entry.getValue();
                baseMap.put(key.substring(1), value);
                continue;
            }
            value = entry.getValue();
            if (baseMap.containsKey(key)) {
                Object existingValue = baseMap.get(key);
                if (existingValue instanceof Map && value instanceof Map) {
                    Map existingMap = (Map)existingValue;
                    Map newMap = (Map)value;
                    MiscUtils.deepMergeMaps(existingMap, newMap);
                    continue;
                }
                if (existingValue instanceof List && value instanceof List) {
                    List existingList = (List)existingValue;
                    List newList = (List)value;
                    existingList.addAll(newList);
                    continue;
                }
                baseMap.put(key, value);
                continue;
            }
            baseMap.put(key, value);
        }
    }

    public static <T> T requireNonNullIf(T o, boolean condition) {
        if (condition) {
            return Objects.requireNonNull(o);
        }
        return o;
    }
}

