/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.momirealms.craftengine.core.util.DefaultStringReader;

public final class SNBTReader
extends DefaultStringReader {
    private static final char COMPOUND_START = '{';
    private static final char COMPOUND_END = '}';
    private static final char LIST_START = '[';
    private static final char LIST_END = ']';
    private static final char STRING_DELIMITER = '\"';
    private static final char SINGLE_QUOTES = '\'';
    private static final char DOUBLE_QUOTES = '\"';
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final char ELEMENT_SEPARATOR = ',';
    private static final char ARRAY_DELIMITER = ';';
    private static final char BYTE_ARRAY = 'b';
    private static final char INT_ARRAY = 'i';
    private static final char LONG_ARRAY = 'l';

    public SNBTReader(String content) {
        super(content);
    }

    public Object deserializeAsJava() {
        Object result = this.parseValue();
        this.skipWhitespace();
        if (this.getCursor() != this.getTotalLength()) {
            throw new IllegalArgumentException("Extra content at end: " + this.substring(this.getCursor(), this.getTotalLength()));
        }
        return result;
    }

    private Object parseValue() {
        this.skipWhitespace();
        return switch (this.peek()) {
            case '{' -> this.parseCompound();
            case '[' -> this.parseList();
            case '\"' -> {
                this.skip();
                yield this.readStringUntil('\"');
            }
            case '\'' -> {
                this.skip();
                yield this.readStringUntil('\'');
            }
            default -> this.parsePrimitive();
        };
    }

    private Map<String, Object> parseCompound() {
        this.skip();
        this.skipWhitespace();
        LinkedHashMap<String, Object> compoundMap = new LinkedHashMap<String, Object>();
        if (this.canRead() && this.peek() != '}') {
            do {
                String key = this.parseKey();
                if (!this.canRead() || this.peek() != ':') {
                    throw new IllegalArgumentException("Expected ':' at position " + this.getCursor());
                }
                this.skip();
                Object value = this.parseValue();
                compoundMap.put(key, value);
                this.skipWhitespace();
            } while (this.canRead() && this.peek() == ',' && ++this.cursor > 0);
        }
        if (!this.canRead() || this.peek() != '}') {
            throw new IllegalArgumentException("Expected '}' at position " + this.getCursor());
        }
        this.skip();
        return compoundMap;
    }

    private Object parseList() {
        this.skip();
        this.skipWhitespace();
        if (this.canRead()) {
            this.setMarker(this.cursor);
            char typeChar = Character.toLowerCase(this.peek());
            if (typeChar == 'b' || typeChar == 'i' || typeChar == 'l') {
                this.skip();
                this.skipWhitespace();
                if (this.canRead() && this.peek() == ';') {
                    this.skip();
                    switch (typeChar) {
                        case 'b': {
                            return this.parseArray(list -> {
                                byte[] bytes = new byte[list.size()];
                                for (int i = 0; i < bytes.length; ++i) {
                                    bytes[i] = ((Number)list.get(i)).byteValue();
                                }
                                return bytes;
                            });
                        }
                        case 'i': {
                            return this.parseArray(list -> {
                                int[] ints = new int[list.size()];
                                for (int i = 0; i < ints.length; ++i) {
                                    ints[i] = ((Number)list.get(i)).intValue();
                                }
                                return ints;
                            });
                        }
                        case 'l': {
                            return this.parseArray(list -> {
                                long[] longs = new long[list.size()];
                                for (int i = 0; i < longs.length; ++i) {
                                    longs[i] = ((Number)list.get(i)).longValue();
                                }
                                return longs;
                            });
                        }
                    }
                }
            }
            this.restore();
        }
        ArrayList<Object> elementList = new ArrayList<Object>();
        if (this.canRead() && this.peek() != ']') {
            do {
                elementList.add(this.parseValue());
                this.skipWhitespace();
            } while (this.canRead() && this.peek() == ',' && ++this.cursor > 0);
        }
        if (!this.canRead() || this.peek() != ']') {
            throw new IllegalArgumentException("Expected ']' at position " + this.getCursor());
        }
        this.skip();
        return elementList;
    }

    private Object parseArray(Function<List<Number>, Object> convertor) {
        this.skipWhitespace();
        ArrayList<Number> elements = new ArrayList<Number>();
        if (this.canRead() && this.peek() != ']') {
            do {
                Object element;
                if (!((element = this.parseValue()) instanceof Number)) {
                    throw new IllegalArgumentException("Error parsing number at pos " + this.getCursor());
                }
                Number number = (Number)element;
                elements.add(number);
                this.skipWhitespace();
            } while (this.canRead() && this.peek() == ',' && ++this.cursor > 0);
        }
        if (!this.canRead() || this.peek() != ']') {
            throw new IllegalArgumentException("Expected ']' at position " + this.getCursor());
        }
        this.skip();
        return convertor.apply(elements);
    }

    private String parseKey() {
        char c;
        this.skipWhitespace();
        if (!this.canRead()) {
            throw new IllegalArgumentException("Unterminated key at " + this.getCursor());
        }
        char peek = this.peek();
        if (peek == '\"') {
            this.skip();
            return this.readStringUntil('\"');
        }
        if (peek == '\'') {
            this.skip();
            return this.readStringUntil('\'');
        }
        int start = this.getCursor();
        while (this.canRead() && (c = this.peek()) != ' ' && Character.isJavaIdentifierPart(c)) {
            this.skip();
        }
        String key = this.substring(start, this.getCursor());
        this.skipWhitespace();
        return key;
    }

    private Object parsePrimitive() {
        char c;
        int tokenStart = this.getCursor();
        int lastWhitespace = 0;
        boolean contentHasWhitespace = false;
        while (this.canRead() && (c = this.peek()) != ',' && c != ']' && c != '}') {
            this.skip();
            if (c == ' ') {
                ++lastWhitespace;
                continue;
            }
            if (lastWhitespace <= 0) continue;
            lastWhitespace = 0;
            contentHasWhitespace = true;
        }
        int tokenLength = this.getCursor() - tokenStart - lastWhitespace;
        if (tokenLength == 0) {
            return null;
        }
        if (contentHasWhitespace) {
            return this.substring(tokenStart, tokenStart + tokenLength);
        }
        if (tokenLength == 4) {
            if (this.matchesAt(tokenStart, "true")) {
                return Boolean.TRUE;
            }
            if (this.matchesAt(tokenStart, "null")) {
                return null;
            }
        } else if (tokenLength == 5 && this.matchesAt(tokenStart, "false")) {
            return Boolean.FALSE;
        }
        if (tokenLength > 1) {
            char lastChar = this.charAt(tokenStart + tokenLength - 1);
            switch (lastChar) {
                case 'B': 
                case 'b': {
                    return Byte.parseByte(this.substring(tokenStart, tokenStart + tokenLength - 1));
                }
                case 'S': 
                case 's': {
                    return Short.parseShort(this.substring(tokenStart, tokenStart + tokenLength - 1));
                }
                case 'L': 
                case 'l': {
                    return Long.parseLong(this.substring(tokenStart, tokenStart + tokenLength - 1));
                }
                case 'F': 
                case 'f': {
                    return Float.valueOf(Float.parseFloat(this.substring(tokenStart, tokenStart + tokenLength)));
                }
                case 'D': 
                case 'd': {
                    return Double.parseDouble(this.substring(tokenStart, tokenStart + tokenLength));
                }
            }
            String fullString = this.substring(tokenStart, tokenStart + tokenLength);
            try {
                double d = Double.parseDouble(fullString);
                if (d % 1.0 != 0.0 || fullString.contains(".") || fullString.contains("e")) {
                    return d;
                }
                return (int)d;
            }
            catch (NumberFormatException e) {
                try {
                    return fullString;
                }
                catch (NumberFormatException e2) {
                    return this.substring(tokenStart, tokenStart + tokenLength);
                }
            }
        }
        char onlyChar = this.charAt(tokenStart);
        if (SNBTReader.isNumber(onlyChar)) {
            return onlyChar - 48;
        }
        return String.valueOf(onlyChar);
    }

    private boolean matchesAt(int start, String target) {
        for (int i = 0; i < target.length(); ++i) {
            char c2;
            char c1 = this.charAt(start + i);
            if (c1 == (c2 = target.charAt(i)) || c1 == (c2 ^ 0x20)) continue;
            return false;
        }
        return true;
    }
}

