/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CollectionTag;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;
import net.momirealms.craftengine.libraries.nbt.util.ArrayUtil;

public class ByteArrayTag
extends CollectionTag<ByteTag> {
    private byte[] value;

    public ByteArrayTag(byte[] value) {
        this.value = value;
    }

    @Override
    public ByteTag get(int index) {
        return new ByteTag(this.value[index]);
    }

    @Override
    public ByteTag set(int index, ByteTag tag) {
        byte b0 = this.value[index];
        this.value[index] = tag.getAsByte();
        return new ByteTag(b0);
    }

    @Override
    public void add(int index, ByteTag tag) {
        this.value = ArrayUtil.add(this.value, index, tag.getAsByte());
    }

    @Override
    public ByteTag remove(int index) {
        byte b0 = this.value[index];
        this.value = ArrayUtil.remove(this.value, index);
        return new ByteTag(b0);
    }

    @Override
    public boolean setTag(int index, Tag tag) {
        if (tag instanceof NumericTag) {
            this.value[index] = ((NumericTag)tag).getAsByte();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int index, Tag tag) {
        if (tag instanceof NumericTag) {
            this.value = ArrayUtil.add(this.value, index, ((NumericTag)tag).getAsByte());
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.value.length);
        output.write(this.value);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public TagType<?> getType() {
        return TagTypes.BYTE_ARRAY;
    }

    @Override
    public ByteArrayTag deepClone() {
        return new ByteArrayTag((byte[])this.value.clone());
    }

    @Override
    public ByteArrayTag copy() {
        return this.deepClone();
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitByteArray(this);
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteArrayTag)) {
            return false;
        }
        ByteArrayTag byteTags = (ByteArrayTag)o;
        return Arrays.equals(this.value, byteTags.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public void clear() {
        this.value = new byte[0];
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    public byte[] getAsByteArray() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }
}

