/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataOutput;
import java.io.IOException;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;

public class IntTag
extends NumericTag {
    private final int value;

    public IntTag(int value) {
        this.value = value;
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public int getAsInt() {
        return this.value;
    }

    @Override
    public short getAsShort() {
        return (short)(this.value & 0xFFFF);
    }

    @Override
    public byte getAsByte() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    @Override
    public float getAsFloat() {
        return this.value;
    }

    @Override
    public Number getAsNumber() {
        return this.value;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.value);
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public TagType<?> getType() {
        return TagTypes.INT;
    }

    @Override
    public IntTag deepClone() {
        return new IntTag(this.value);
    }

    @Override
    public IntTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitInt(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntTag)) {
            return false;
        }
        IntTag intTag = (IntTag)o;
        return this.value == intTag.value;
    }

    public int hashCode() {
        return this.value;
    }
}

